/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.common;

/**
 * Common place for constants used across all event types
 * @author akmathur
 *
 */
public interface IXMLEventConstants {
	/** The following constants are used by the 'conflict' field of the 
	 * ExecutionEvent class. This helps edcide what to do in the loader
	 * when we get a duplicate event.
	 */
	/** Just insert this event in the execution history - No Conflict determination needed **/
	public static final int CONFLICT_NONE = 0;
	/** If an event with IDs exist, then ignore this event **/
	public static final int CONFLICT_IGNORE = 1;
	/** If this event already exists, just overwrite it with the current event **/
	public static final int CONFLICT_OVERWRITE = 2;
	/** Overwrite an existing event if this event is an earlier one **/
	public static final int CONFLICT_OVERWRITE_IF_EARLIEST = 3;
	/** Overwrite an existing event if this event is the later one **/
	public static final int CONFLICT_OVERWRITE_IF_LATEST = 4;
}
