/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.common;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationReason;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationStatus;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.impl.Common_TestprofileFactoryImpl;

/**
 * @author amathur
 *
 * This is the invocation event loader.
 */
public class XMLinvocationEventLoader extends XMLexecutionEventLoader {
	// Static variables
	protected final static String EVENT_INVOCATION_REASON = "reason";
	protected final static String EVENT_INVOCATION_STATUS = "status";
	
	// Attribute variables
	protected TPFInvocationStatus invocationStatus = null;
	protected TPFInvocationReason invocationReason = null;

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
	 */
	public void initialize(HierarchyContext context, String name) {
		super.initialize(context, name);
		invocationStatus = null;
		invocationReason = null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addAttribute(java.lang.String, java.lang.String)
	 */
	public void addAttribute(String name, String value) {
		printAttribute(name, value);
		switch (LoadersUtils.getHashCode(name)) {
			case ExecutionConstants.EVENT_INVOCATION_STATUS_int :
				invocationStatus = TPFInvocationStatus.get(Integer.parseInt(value));
				break;

			case ExecutionConstants.EVENT_INVOCATION_REASON_int :
				invocationReason = TPFInvocationReason.get(value);
				break;

			default :
				super.addAttribute(name, value);
				break;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addYourselfInContext()
	 */
	public void addYourselfInContext() {
		// Create the event
		TPFInvocationEvent event = Common_TestprofileFactoryImpl.eINSTANCE.createTPFInvocationEvent();
		ExecutionContext eContext = (ExecutionContext) context.getCustomData().get(ExecutionContext.root);
		
		// Now populate the specialized attributes
		event.setStatus(invocationStatus);
		event.setReason(invocationReason);
		
		// populate the event with the base event attributes
		this.event = (TPFExecutionEvent) event;
		super.addYourselfInContext();
		super.addYourselfToContainer();
		
		// Now fix up relationships that are specific to this type of execution event.
		// (Only do this if we are using the new XML fragment structure -- if we're
		// using the old structure, then this logic is all coded in the ExecutionContext
		// logEvent method.)
		if ( parentId != null )
		{
			// Override the ownerId
			TPFTest theTest = getReferencedTest();
			if ( theTest == null )
			{
				theTest = eContext.getTestSuite();
			}
			EObject testElement = ExecutionResultData.getObjectFromTest(
				theTest, ownerId);
			
			if ( testElement != null && testElement instanceof BVRExecutionOccurrence )
			{
				event.setInteractionFragment((BVRInteractionFragment)testElement);
				TPFBehavior behavior = ((BVRExecutionOccurrence)testElement).getOtherBehavior();
				if ( behavior != null )
				{
					theTest = behavior.getTest();
				}
			}
			
			TPFInvocationEvent invocationEvent = (TPFInvocationEvent) event;
			TPFExecutionResult exResult = invocationEvent.getInvokedExecutionResult();

			if ( exResult == null )
			{
				// This is the first event for this invocation, so create a
				// new execution result and execution history for it.
				ExecutionResultData data = new ExecutionResultData(theTest, event.getOwnerId());
				data.setInvocationEvent(invocationEvent);
				exResult = data.getResult();					
			}
			else
			{
				// @akmathur: This is possible in the new scheme of conflict-resolution
				// Its possible to get an event of the exact nature multiple times 
				// (from multiple agents in a load test). If this happens, just
				// ignore the event
			}
		}
	}
	
	/**
	 * @see org.eclipse.hyades.loaders.common.XMLexecutionEventLoader#overwrite(org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent)
	 */
	protected void overwrite(TPFExecutionEvent match) {
		super.overwrite(match);
		((TPFInvocationEvent) match).setReason(((TPFInvocationEvent)event).getReason());
		((TPFInvocationEvent) match).setStatus(((TPFInvocationEvent)event).getStatus());
	}
}
