/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.interactions.impl;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.common.CMNAnnotation;

import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.facades.behavioral.IPropertyGroup;
import org.eclipse.hyades.models.common.facades.behavioral.impl.PropertyGroupImpl;
import org.eclipse.hyades.models.common.fragments.BVRInteraction;
import org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage;
import org.eclipse.hyades.models.common.interactions.BVRGeneralOrdering;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.interactions.BVRLifeline;
import org.eclipse.hyades.models.common.interactions.BVRMessage;
import org.eclipse.hyades.models.common.interactions.BVRProperty;
import org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFDefaultApplication;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>BVR Interaction Fragment</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl#getLifelines <em>Lifelines</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl#getGeneralOrderings <em>General Orderings</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl#getMessages <em>Messages</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl#getAnnotations <em>Annotations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl#getInteraction <em>Interaction</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl#getProperties <em>Properties</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl#getDefaultApplication <em>Default Application</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class BVRInteractionFragmentImpl extends CMNNamedElementImpl implements BVRInteractionFragment
{
    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public static final String copyright = "";

    /**
     * The cached value of the '{@link #getLifelines() <em>Lifelines</em>}' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getLifelines()
     * @generated
     * @ordered
     */
	protected EList lifelines = null;

    /**
     * The cached value of the '{@link #getGeneralOrderings() <em>General Orderings</em>}' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getGeneralOrderings()
     * @generated
     * @ordered
     */
	protected EList generalOrderings = null;

    /**
     * The cached value of the '{@link #getMessages() <em>Messages</em>}' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getMessages()
     * @generated
     * @ordered
     */
	protected EList messages = null;

    /**
     * The cached value of the '{@link #getAnnotations() <em>Annotations</em>}' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getAnnotations()
     * @generated
     * @ordered
     */
	protected EList annotations = null;

    /**
     * The cached value of the '{@link #getProperties() <em>Properties</em>}' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getProperties()
     * @generated
     * @ordered
     */
	protected EList properties = null;

    /**
     * The cached value of the '{@link #getDefaultApplication() <em>Default Application</em>}' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getDefaultApplication()
     * @generated
     * @ordered
     */
	protected TPFDefaultApplication defaultApplication = null;

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected BVRInteractionFragmentImpl()
    {
        super();
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected EClass eStaticClass()
    {
        return Common_Behavior_InteractionsPackage.eINSTANCE.getBVRInteractionFragment();
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList getLifelines()
    {
        if (lifelines == null)
        {
            lifelines = new EObjectWithInverseResolvingEList.ManyInverse(BVRLifeline.class, this, Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__LIFELINES, Common_Behavior_InteractionsPackage.BVR_LIFELINE__INTERACTION_FRAGMENTS);
        }
        return lifelines;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList getGeneralOrderings()
    {
        if (generalOrderings == null)
        {
            generalOrderings = new EObjectContainmentEList(BVRGeneralOrdering.class, this, Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__GENERAL_ORDERINGS);
        }
        return generalOrderings;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList getMessages()
    {
        if (messages == null)
        {
            messages = new EObjectContainmentWithInverseEList(BVRMessage.class, this, Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__MESSAGES, Common_Behavior_InteractionsPackage.BVR_MESSAGE__INTERACTION_FRAGMENT);
        }
        return messages;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList getAnnotations()
    {
        if (annotations == null)
        {
            annotations = new EObjectContainmentEList(CMNAnnotation.class, this, Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__ANNOTATIONS);
        }
        return annotations;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public BVRInteraction getInteraction()
    {
        if (eContainerFeatureID != Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__INTERACTION) return null;
        return (BVRInteraction)eContainer;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setInteraction(BVRInteraction newInteraction)
    {
        if (newInteraction != eContainer || (eContainerFeatureID != Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__INTERACTION && newInteraction != null))
        {
            if (EcoreUtil.isAncestor(this, newInteraction))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eContainer != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newInteraction != null)
                msgs = ((InternalEObject)newInteraction).eInverseAdd(this, Common_Behavior_FragmentsPackage.BVR_INTERACTION__INTERACTION_FRAGMENTS, BVRInteraction.class, msgs);
            msgs = eBasicSetContainer((InternalEObject)newInteraction, Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__INTERACTION, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__INTERACTION, newInteraction, newInteraction));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList getProperties()
    {
        if (properties == null)
        {
            properties = new EObjectContainmentEList(BVRProperty.class, this, Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__PROPERTIES);
        }
        return properties;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public TPFDefaultApplication getDefaultApplication()
    {
        return defaultApplication;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain basicSetDefaultApplication(TPFDefaultApplication newDefaultApplication, NotificationChain msgs)
    {
        TPFDefaultApplication oldDefaultApplication = defaultApplication;
        defaultApplication = newDefaultApplication;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__DEFAULT_APPLICATION, oldDefaultApplication, newDefaultApplication);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setDefaultApplication(TPFDefaultApplication newDefaultApplication)
    {
        if (newDefaultApplication != defaultApplication)
        {
            NotificationChain msgs = null;
            if (defaultApplication != null)
                msgs = ((InternalEObject)defaultApplication).eInverseRemove(this, Common_TestprofilePackage.TPF_DEFAULT_APPLICATION__INTERACTION_FRAGMENT, TPFDefaultApplication.class, msgs);
            if (newDefaultApplication != null)
                msgs = ((InternalEObject)newDefaultApplication).eInverseAdd(this, Common_TestprofilePackage.TPF_DEFAULT_APPLICATION__INTERACTION_FRAGMENT, TPFDefaultApplication.class, msgs);
            msgs = basicSetDefaultApplication(newDefaultApplication, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__DEFAULT_APPLICATION, newDefaultApplication, newDefaultApplication));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
    {
        if (featureID >= 0)
        {
            switch (eDerivedStructuralFeatureID(featureID, baseClass))
            {
                case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__LIFELINES:
                    return ((InternalEList)getLifelines()).basicAdd(otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__MESSAGES:
                    return ((InternalEList)getMessages()).basicAdd(otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__INTERACTION:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__INTERACTION, msgs);
                case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__DEFAULT_APPLICATION:
                    if (defaultApplication != null)
                        msgs = ((InternalEObject)defaultApplication).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__DEFAULT_APPLICATION, null, msgs);
                    return basicSetDefaultApplication((TPFDefaultApplication)otherEnd, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
    {
        if (featureID >= 0)
        {
            switch (eDerivedStructuralFeatureID(featureID, baseClass))
            {
                case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__LIFELINES:
                    return ((InternalEList)getLifelines()).basicRemove(otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__GENERAL_ORDERINGS:
                    return ((InternalEList)getGeneralOrderings()).basicRemove(otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__MESSAGES:
                    return ((InternalEList)getMessages()).basicRemove(otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__ANNOTATIONS:
                    return ((InternalEList)getAnnotations()).basicRemove(otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__INTERACTION:
                    return eBasicSetContainer(null, Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__INTERACTION, msgs);
                case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__PROPERTIES:
                    return ((InternalEList)getProperties()).basicRemove(otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__DEFAULT_APPLICATION:
                    return basicSetDefaultApplication(null, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs)
    {
        if (eContainerFeatureID >= 0)
        {
            switch (eContainerFeatureID)
            {
                case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__INTERACTION:
                    return ((InternalEObject)eContainer).eInverseRemove(this, Common_Behavior_FragmentsPackage.BVR_INTERACTION__INTERACTION_FRAGMENTS, BVRInteraction.class, msgs);
                default:
                    return eDynamicBasicRemoveFromContainer(msgs);
            }
        }
        return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__ID:
                return getId();
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__DESCRIPTION:
                return getDescription();
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__NAME:
                return getName();
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__LIFELINES:
                return getLifelines();
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__GENERAL_ORDERINGS:
                return getGeneralOrderings();
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__MESSAGES:
                return getMessages();
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__ANNOTATIONS:
                return getAnnotations();
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__INTERACTION:
                return getInteraction();
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__PROPERTIES:
                return getProperties();
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__DEFAULT_APPLICATION:
                return getDefaultApplication();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void eSet(EStructuralFeature eFeature, Object newValue)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__ID:
                setId((String)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__DESCRIPTION:
                setDescription((String)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__NAME:
                setName((String)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__LIFELINES:
                getLifelines().clear();
                getLifelines().addAll((Collection)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__GENERAL_ORDERINGS:
                getGeneralOrderings().clear();
                getGeneralOrderings().addAll((Collection)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__MESSAGES:
                getMessages().clear();
                getMessages().addAll((Collection)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__ANNOTATIONS:
                getAnnotations().clear();
                getAnnotations().addAll((Collection)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__INTERACTION:
                setInteraction((BVRInteraction)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__PROPERTIES:
                getProperties().clear();
                getProperties().addAll((Collection)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__DEFAULT_APPLICATION:
                setDefaultApplication((TPFDefaultApplication)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void eUnset(EStructuralFeature eFeature)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__ID:
                setId(ID_EDEFAULT);
                return;
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__DESCRIPTION:
                setDescription(DESCRIPTION_EDEFAULT);
                return;
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__NAME:
                setName(NAME_EDEFAULT);
                return;
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__LIFELINES:
                getLifelines().clear();
                return;
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__GENERAL_ORDERINGS:
                getGeneralOrderings().clear();
                return;
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__MESSAGES:
                getMessages().clear();
                return;
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__ANNOTATIONS:
                getAnnotations().clear();
                return;
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__INTERACTION:
                setInteraction((BVRInteraction)null);
                return;
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__PROPERTIES:
                getProperties().clear();
                return;
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__DEFAULT_APPLICATION:
                setDefaultApplication((TPFDefaultApplication)null);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public boolean eIsSet(EStructuralFeature eFeature)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__ID:
                return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__DESCRIPTION:
                return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__NAME:
                return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__LIFELINES:
                return lifelines != null && !lifelines.isEmpty();
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__GENERAL_ORDERINGS:
                return generalOrderings != null && !generalOrderings.isEmpty();
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__MESSAGES:
                return messages != null && !messages.isEmpty();
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__ANNOTATIONS:
                return annotations != null && !annotations.isEmpty();
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__INTERACTION:
                return getInteraction() != null;
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__PROPERTIES:
                return properties != null && !properties.isEmpty();
            case Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__DEFAULT_APPLICATION:
                return defaultApplication != null;
        }
        return eDynamicIsSet(eFeature);
    }

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAction#getActionProperties()
	 */
	public IPropertyGroup getActionProperties() {
		PropertyGroupImpl propertyGroup = new PropertyGroupImpl();
		propertyGroup.setProperties(getProperties());
		return propertyGroup;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAction#isSynchronous()
	 */
	public boolean isSynchronous() {
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAction#setSynchronous(boolean)
	 */
	public void setSynchronous(boolean synchronous)
		throws UnsupportedOperationException {
		
		throw new UnsupportedOperationException("");
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAction#getActionAnnotations()
	 */
	public List getActionAnnotations() {
		return getAnnotations();
	}
} //BVRInteractionFragmentImpl
