/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.interactions.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.configuration.CFGOperation;
import org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl;
import org.eclipse.hyades.models.common.configuration.impl.CFGInstanceImpl;
import org.eclipse.hyades.models.common.configuration.impl.CFGOperationImpl;
import org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent;
import org.eclipse.hyades.models.common.facades.behavioral.IMethod;
import org.eclipse.hyades.models.common.facades.behavioral.ITargetInvocation;
import org.eclipse.hyades.models.common.fragments.BVRInteraction;
import org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage;
import org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence;
import org.eclipse.hyades.models.common.interactions.BVRMessage;
import org.eclipse.hyades.models.common.interactions.BVRMessageEnd;
import org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage;
import org.eclipse.hyades.models.common.testprofile.TPFDefaultApplication;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>BVR Message End</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRMessageEndImpl#getReceiveMessage <em>Receive Message</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRMessageEndImpl#getSendMessage <em>Send Message</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class BVRMessageEndImpl extends BVREventOccurrenceImpl implements BVRMessageEnd
{
    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public static final String copyright = "";

    /**
     * The cached value of the '{@link #getReceiveMessage() <em>Receive Message</em>}' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getReceiveMessage()
     * @generated
     * @ordered
     */
	protected BVRMessage receiveMessage = null;

    /**
     * The cached value of the '{@link #getSendMessage() <em>Send Message</em>}' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getSendMessage()
     * @generated
     * @ordered
     */
	protected BVRMessage sendMessage = null;

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected BVRMessageEndImpl()
    {
        super();
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected EClass eStaticClass()
    {
        return Common_Behavior_InteractionsPackage.eINSTANCE.getBVRMessageEnd();
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public BVRMessage getReceiveMessage()
    {
        if (receiveMessage != null && receiveMessage.eIsProxy())
        {
            BVRMessage oldReceiveMessage = receiveMessage;
            receiveMessage = (BVRMessage)eResolveProxy((InternalEObject)receiveMessage);
            if (receiveMessage != oldReceiveMessage)
            {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__RECEIVE_MESSAGE, oldReceiveMessage, receiveMessage));
            }
        }
        return receiveMessage;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public BVRMessage basicGetReceiveMessage()
    {
        return receiveMessage;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain basicSetReceiveMessage(BVRMessage newReceiveMessage, NotificationChain msgs)
    {
        BVRMessage oldReceiveMessage = receiveMessage;
        receiveMessage = newReceiveMessage;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__RECEIVE_MESSAGE, oldReceiveMessage, newReceiveMessage);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setReceiveMessage(BVRMessage newReceiveMessage)
    {
        if (newReceiveMessage != receiveMessage)
        {
            NotificationChain msgs = null;
            if (receiveMessage != null)
                msgs = ((InternalEObject)receiveMessage).eInverseRemove(this, Common_Behavior_InteractionsPackage.BVR_MESSAGE__RECEIVE_MESSAGE_END, BVRMessage.class, msgs);
            if (newReceiveMessage != null)
                msgs = ((InternalEObject)newReceiveMessage).eInverseAdd(this, Common_Behavior_InteractionsPackage.BVR_MESSAGE__RECEIVE_MESSAGE_END, BVRMessage.class, msgs);
            msgs = basicSetReceiveMessage(newReceiveMessage, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__RECEIVE_MESSAGE, newReceiveMessage, newReceiveMessage));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public BVRMessage getSendMessage()
    {
        if (sendMessage != null && sendMessage.eIsProxy())
        {
            BVRMessage oldSendMessage = sendMessage;
            sendMessage = (BVRMessage)eResolveProxy((InternalEObject)sendMessage);
            if (sendMessage != oldSendMessage)
            {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__SEND_MESSAGE, oldSendMessage, sendMessage));
            }
        }
        return sendMessage;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public BVRMessage basicGetSendMessage()
    {
        return sendMessage;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain basicSetSendMessage(BVRMessage newSendMessage, NotificationChain msgs)
    {
        BVRMessage oldSendMessage = sendMessage;
        sendMessage = newSendMessage;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__SEND_MESSAGE, oldSendMessage, newSendMessage);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setSendMessage(BVRMessage newSendMessage)
    {
        if (newSendMessage != sendMessage)
        {
            NotificationChain msgs = null;
            if (sendMessage != null)
                msgs = ((InternalEObject)sendMessage).eInverseRemove(this, Common_Behavior_InteractionsPackage.BVR_MESSAGE__SEND_MESSAGE_END, BVRMessage.class, msgs);
            if (newSendMessage != null)
                msgs = ((InternalEObject)newSendMessage).eInverseAdd(this, Common_Behavior_InteractionsPackage.BVR_MESSAGE__SEND_MESSAGE_END, BVRMessage.class, msgs);
            msgs = basicSetSendMessage(newSendMessage, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__SEND_MESSAGE, newSendMessage, newSendMessage));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
    {
        if (featureID >= 0)
        {
            switch (eDerivedStructuralFeatureID(featureID, baseClass))
            {
                case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__LIFELINES:
                    return ((InternalEList)getLifelines()).basicAdd(otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__MESSAGES:
                    return ((InternalEList)getMessages()).basicAdd(otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__INTERACTION:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__INTERACTION, msgs);
                case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__DEFAULT_APPLICATION:
                    if (defaultApplication != null)
                        msgs = ((InternalEObject)defaultApplication).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__DEFAULT_APPLICATION, null, msgs);
                    return basicSetDefaultApplication((TPFDefaultApplication)otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__TARGET_GENERAL_ORDERINGS:
                    return ((InternalEList)getTargetGeneralOrderings()).basicAdd(otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__SOURCE_GENERAL_ORDERINGS:
                    return ((InternalEList)getSourceGeneralOrderings()).basicAdd(otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__FINISH_EXECUTION_OCCURRENCE:
                    if (finishExecutionOccurrence != null)
                        msgs = ((InternalEObject)finishExecutionOccurrence).eInverseRemove(this, Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__FINISH_EVENT_OCCURRENCE, BVRExecutionOccurrence.class, msgs);
                    return basicSetFinishExecutionOccurrence((BVRExecutionOccurrence)otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__START_EXECUTION_OCURRENCE:
                    if (startExecutionOcurrence != null)
                        msgs = ((InternalEObject)startExecutionOcurrence).eInverseRemove(this, Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__BEFORE_EVENT_OCCURRENCE, BVRExecutionOccurrence.class, msgs);
                    return basicSetStartExecutionOcurrence((BVRExecutionOccurrence)otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__RECEIVE_MESSAGE:
                    if (receiveMessage != null)
                        msgs = ((InternalEObject)receiveMessage).eInverseRemove(this, Common_Behavior_InteractionsPackage.BVR_MESSAGE__RECEIVE_MESSAGE_END, BVRMessage.class, msgs);
                    return basicSetReceiveMessage((BVRMessage)otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__SEND_MESSAGE:
                    if (sendMessage != null)
                        msgs = ((InternalEObject)sendMessage).eInverseRemove(this, Common_Behavior_InteractionsPackage.BVR_MESSAGE__SEND_MESSAGE_END, BVRMessage.class, msgs);
                    return basicSetSendMessage((BVRMessage)otherEnd, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
    {
        if (featureID >= 0)
        {
            switch (eDerivedStructuralFeatureID(featureID, baseClass))
            {
                case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__LIFELINES:
                    return ((InternalEList)getLifelines()).basicRemove(otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__GENERAL_ORDERINGS:
                    return ((InternalEList)getGeneralOrderings()).basicRemove(otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__MESSAGES:
                    return ((InternalEList)getMessages()).basicRemove(otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__ANNOTATIONS:
                    return ((InternalEList)getAnnotations()).basicRemove(otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__INTERACTION:
                    return eBasicSetContainer(null, Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__INTERACTION, msgs);
                case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__PROPERTIES:
                    return ((InternalEList)getProperties()).basicRemove(otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__DEFAULT_APPLICATION:
                    return basicSetDefaultApplication(null, msgs);
                case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__TARGET_GENERAL_ORDERINGS:
                    return ((InternalEList)getTargetGeneralOrderings()).basicRemove(otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__SOURCE_GENERAL_ORDERINGS:
                    return ((InternalEList)getSourceGeneralOrderings()).basicRemove(otherEnd, msgs);
                case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__FINISH_EXECUTION_OCCURRENCE:
                    return basicSetFinishExecutionOccurrence(null, msgs);
                case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__START_EXECUTION_OCURRENCE:
                    return basicSetStartExecutionOcurrence(null, msgs);
                case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__RECEIVE_MESSAGE:
                    return basicSetReceiveMessage(null, msgs);
                case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__SEND_MESSAGE:
                    return basicSetSendMessage(null, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs)
    {
        if (eContainerFeatureID >= 0)
        {
            switch (eContainerFeatureID)
            {
                case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__INTERACTION:
                    return ((InternalEObject)eContainer).eInverseRemove(this, Common_Behavior_FragmentsPackage.BVR_INTERACTION__INTERACTION_FRAGMENTS, BVRInteraction.class, msgs);
                default:
                    return eDynamicBasicRemoveFromContainer(msgs);
            }
        }
        return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__ID:
                return getId();
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__DESCRIPTION:
                return getDescription();
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__NAME:
                return getName();
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__LIFELINES:
                return getLifelines();
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__GENERAL_ORDERINGS:
                return getGeneralOrderings();
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__MESSAGES:
                return getMessages();
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__ANNOTATIONS:
                return getAnnotations();
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__INTERACTION:
                return getInteraction();
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__PROPERTIES:
                return getProperties();
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__DEFAULT_APPLICATION:
                return getDefaultApplication();
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__TARGET_GENERAL_ORDERINGS:
                return getTargetGeneralOrderings();
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__SOURCE_GENERAL_ORDERINGS:
                return getSourceGeneralOrderings();
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__FINISH_EXECUTION_OCCURRENCE:
                if (resolve) return getFinishExecutionOccurrence();
                return basicGetFinishExecutionOccurrence();
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__START_EXECUTION_OCURRENCE:
                if (resolve) return getStartExecutionOcurrence();
                return basicGetStartExecutionOcurrence();
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__RECEIVE_MESSAGE:
                if (resolve) return getReceiveMessage();
                return basicGetReceiveMessage();
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__SEND_MESSAGE:
                if (resolve) return getSendMessage();
                return basicGetSendMessage();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void eSet(EStructuralFeature eFeature, Object newValue)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__ID:
                setId((String)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__DESCRIPTION:
                setDescription((String)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__NAME:
                setName((String)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__LIFELINES:
                getLifelines().clear();
                getLifelines().addAll((Collection)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__GENERAL_ORDERINGS:
                getGeneralOrderings().clear();
                getGeneralOrderings().addAll((Collection)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__MESSAGES:
                getMessages().clear();
                getMessages().addAll((Collection)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__ANNOTATIONS:
                getAnnotations().clear();
                getAnnotations().addAll((Collection)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__INTERACTION:
                setInteraction((BVRInteraction)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__PROPERTIES:
                getProperties().clear();
                getProperties().addAll((Collection)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__DEFAULT_APPLICATION:
                setDefaultApplication((TPFDefaultApplication)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__TARGET_GENERAL_ORDERINGS:
                getTargetGeneralOrderings().clear();
                getTargetGeneralOrderings().addAll((Collection)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__SOURCE_GENERAL_ORDERINGS:
                getSourceGeneralOrderings().clear();
                getSourceGeneralOrderings().addAll((Collection)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__FINISH_EXECUTION_OCCURRENCE:
                setFinishExecutionOccurrence((BVRExecutionOccurrence)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__START_EXECUTION_OCURRENCE:
                setStartExecutionOcurrence((BVRExecutionOccurrence)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__RECEIVE_MESSAGE:
                setReceiveMessage((BVRMessage)newValue);
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__SEND_MESSAGE:
                setSendMessage((BVRMessage)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void eUnset(EStructuralFeature eFeature)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__ID:
                setId(ID_EDEFAULT);
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__DESCRIPTION:
                setDescription(DESCRIPTION_EDEFAULT);
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__NAME:
                setName(NAME_EDEFAULT);
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__LIFELINES:
                getLifelines().clear();
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__GENERAL_ORDERINGS:
                getGeneralOrderings().clear();
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__MESSAGES:
                getMessages().clear();
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__ANNOTATIONS:
                getAnnotations().clear();
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__INTERACTION:
                setInteraction((BVRInteraction)null);
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__PROPERTIES:
                getProperties().clear();
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__DEFAULT_APPLICATION:
                setDefaultApplication((TPFDefaultApplication)null);
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__TARGET_GENERAL_ORDERINGS:
                getTargetGeneralOrderings().clear();
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__SOURCE_GENERAL_ORDERINGS:
                getSourceGeneralOrderings().clear();
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__FINISH_EXECUTION_OCCURRENCE:
                setFinishExecutionOccurrence((BVRExecutionOccurrence)null);
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__START_EXECUTION_OCURRENCE:
                setStartExecutionOcurrence((BVRExecutionOccurrence)null);
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__RECEIVE_MESSAGE:
                setReceiveMessage((BVRMessage)null);
                return;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__SEND_MESSAGE:
                setSendMessage((BVRMessage)null);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public boolean eIsSet(EStructuralFeature eFeature)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__ID:
                return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__DESCRIPTION:
                return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__NAME:
                return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__LIFELINES:
                return lifelines != null && !lifelines.isEmpty();
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__GENERAL_ORDERINGS:
                return generalOrderings != null && !generalOrderings.isEmpty();
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__MESSAGES:
                return messages != null && !messages.isEmpty();
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__ANNOTATIONS:
                return annotations != null && !annotations.isEmpty();
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__INTERACTION:
                return getInteraction() != null;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__PROPERTIES:
                return properties != null && !properties.isEmpty();
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__DEFAULT_APPLICATION:
                return defaultApplication != null;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__TARGET_GENERAL_ORDERINGS:
                return targetGeneralOrderings != null && !targetGeneralOrderings.isEmpty();
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__SOURCE_GENERAL_ORDERINGS:
                return sourceGeneralOrderings != null && !sourceGeneralOrderings.isEmpty();
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__FINISH_EXECUTION_OCCURRENCE:
                return finishExecutionOccurrence != null;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__START_EXECUTION_OCURRENCE:
                return startExecutionOcurrence != null;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__RECEIVE_MESSAGE:
                return receiveMessage != null;
            case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__SEND_MESSAGE:
                return sendMessage != null;
        }
        return eDynamicIsSet(eFeature);
    }

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITargetInvocation#getTarget()
	 */
	public IDeployableComponent getTarget() {
		CFGOperationImpl operation = (CFGOperationImpl)getInvocation();
		if ( operation != null )
		{
			return (CFGClassImpl) operation.getOwningClass();
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITargetInvocation#getInvocation()
	 */
	public IMethod getInvocation() {
		BVRMessageImpl msg = (BVRMessageImpl) getMessages().get(0); 
		if ( msg != null )
		{
			CFGOperation operation = msg.getOperation();
			return (CFGOperationImpl) operation;
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITargetInvocation#setInvocation(org.eclipse.hyades.models.common.facades.behavioral.IMethod)
	 */
	public void setInvocation(IMethod method)
	{
		if(method == null)
		{
			if(!getMessages().isEmpty())
			{
				BVRMessage msg = (BVRMessage)getMessages().get(0);
				msg.setOperation(null);
			}
		}
		else
		{
			associateOperationToMessageEnd(method, method.getDeployableComponent());
		}
	}
	
	public void associateOperationToMessageEnd(IMethod method, IDeployableComponent component) 
	{
		BVRMessage msg = null;
		if(getMessages().isEmpty())
		{
			msg = Common_Behavior_InteractionsFactoryImpl.eINSTANCE.createBVRMessage();
			getMessages().add(msg);
		}
		else
			msg = (BVRMessage)getMessages().get(0);
		msg.setOperation((CFGOperationImpl)method);
		
		if(component != null)
		{
			CFGClassImpl cls = (CFGClassImpl)component;
			if(!cls.getInstances().isEmpty())
				getLifelines().add(((CFGInstanceImpl)cls.getInstances().get(0)).getLifeline());
		}			
	}
	
	public void associateOperationToMessageEnd(
		IMethod method)
	{
		// Create a Message
		BVRMessageImpl msg = (BVRMessageImpl)Common_Behavior_InteractionsFactoryImpl.eINSTANCE.createBVRMessage();
		msg.setOperation((CFGOperationImpl)method);

		// TODO: May need to rework in future release if assumptions become false.
		
		// Associate the message with the messagend's message collection (assert only 1 for now)
		// ASSUMPTION: We are using only one message end to represent the message
		this.getMessages().add(msg);		
	}
	
	// TODO: These overrided methods need to be reworked in a future release
	public static final String SYNCHRONIZATION_FLAG = "SYNCRONIZATION_FLAG";

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAction#isSynchronous()
	 */
	public boolean isSynchronous() {
		Iterator iter = getProperties().iterator();
		while(iter.hasNext())
		{
			BVRPropertyImpl property = (BVRPropertyImpl)iter.next();
			if(property.getName().equals(SYNCHRONIZATION_FLAG))
			{
				return Boolean.valueOf(property.getValue()).booleanValue();
			}
		}
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAction#setSynchronous(boolean)
	 */
	public void setSynchronous(boolean synchronous)
		throws UnsupportedOperationException 
	{
		Iterator iter = getProperties().iterator();
		// find the synchronization property and set it
		while(iter.hasNext())
		{
			BVRPropertyImpl property = (BVRPropertyImpl)iter.next();
			if(property.getName().equals(SYNCHRONIZATION_FLAG))
			{
				property.setValue(new Boolean(synchronous).toString());
				return;
			}
		}
		// if the property doesn't exist, create it and set it
		BVRPropertyImpl property = (BVRPropertyImpl)Common_Behavior_InteractionsFactoryImpl.eINSTANCE.createBVRProperty();
		property.setName(SYNCHRONIZATION_FLAG);
		property.setValue(String.valueOf(synchronous));
		List properties = getProperties();
		properties.add(property);
	}
} //BVRMessageEndImpl
