/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.actions.internal;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Status;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.uml2sd.trace.*;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;

import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

import org.eclipse.hyades.models.trace.*;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.*;

import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.ui.load.*;

/**
 * The abstract action that offers to help opening a trace interaction.
 */
public abstract class OpenTraceInteractions extends Action
				implements IWorkbenchWindowActionDelegate, IViewActionDelegate {
					
	/**
	 * OpenReferencePatternView constructor comment.
	 */
	public OpenTraceInteractions() {
		super(""); //$NON-NLS-1$
	}
	/**
	 * OpenReferencePatternView constructor comment.
	 * @param label java.lang.String
	 */
	public OpenTraceInteractions(String label) {
		super(label);
	}
	/**
	 * OpenReferencePatternView constructor comment.
	 * @param label java.lang.String
	 * @param image com.ibm.jface.parts.IImage
	 */
	public OpenTraceInteractions(String label, ImageDescriptor image) {
		super(label, image);
	}

	/**
	 * 
	 */
	public boolean isVisibleForType(Object mofObject) {
		return mofObject instanceof TRCProcess;
	}

	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run() {
		IWorkbenchWindow window =
			UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();

		try {
			IWorkbenchPage persp = UIPlugin.getActivePage();
			SDView view = (SDView) persp.showView("org.eclipse.hyades.uml2sd.ui.view.SDView"); //$NON-NLS-1$
			LoadersManager.getLoadersManager().createLoader(getLoaderClassName(), getClass().getClassLoader(), view);
		} catch (Exception e) {
			String msg = TraceSDPlugin.getResourceString("STR_OPEN_UML2SD_TRACE_INTERACTION_ERROR_"); //$NON-NLS-1$
			Status err =
				new Status(
					Status.WARNING,
					ResourcesPlugin.PI_RESOURCES,
					IResourceStatus.INTERNAL_ERROR,
					e.toString(),
					null);

			ErrorDialog.openError(window.getShell(), msg, "", //$NON-NLS-1$
			// no special message
			err);

			e.printStackTrace();
		}

	}
	
	/**
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		run();
	}
	
	/**
	 * The abstract to be implemented by concrete trace interactions opening actions.
	 * This is the way to know which concrete class is to be instantiated as a loader.
	 * It exists mainly because the id of the org.eclipse.hyades.ui.analyzerExtensions extension point
	 * can not be retrieved.
	 */
	public abstract String getLoaderClassName();

	/**
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#init(org.eclipse.ui.IWorkbenchWindow)
	 */
	public void init(IWorkbenchWindow window) {
	}
	
	/**
	 * Initializes this action delegate with the view it will work in.
	 * @param view the view that provides the context for this delegate
	 */
	public void init(IViewPart view) {
		// try to figure out what do the commented two lines above mean???
	}

	/**
	 * Looks like a dispose...
	 */
	public void dispose() {
		// nothing to do today
	}
	
}
