/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;

/**
 * This is the concrete class for class interaction loader
 */
public class ClassInteractions extends TraceInteractions {

	/**
	 * The lifeline to be used for any instance of a class is the class itself
	 */
	protected EObject getLifelineEObjectFromMethodInvocation(TRCFullMethodInvocation mi) {
		return mi.getMethod().getDefiningClass(); // TRCClass
	}

	/**
	 * The name of the lifeline is the name of the class
	 */
	protected String getLifeLineTitle(EObject eo, boolean long_) {
		TRCClass cl = (TRCClass)eo;
		return cl.getName() +
			   (!long_ && cl.getPackage() != null ? (" ("+cl.getPackage().getName()+")") : ""); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-2 //$NON-NLS-3$
	}

	/**
	 * The category of such a lifeline is invariably the Classes category
	 */
	protected int getLifeLineCategory(EObject eo) {
		return TraceInteractions.CATEGORY_CLASSES;
	}
	
	/**
	 * This is the class interactions, nothing else
	 */
	public String getFinalTitleString() {
		return TraceSDPlugin.getResourceString("STR_UML2SD_CLASS_INTERACTION"); //$NON-NLS-1$
	}
	
}
