/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders.internal;


/**
 * A class to be thrown when a page containing what we are looking for is found.<br>
 * It carries the page number.
 */
public class FoundInPage extends Error {

	private int page;
	
	/**
	 * @param page_
	 */
	public FoundInPage(int page_) {
		setPage(page_);
	}
	
	/**
	 * @param page_
	 */
	public void setPage(int page_) {
		page = page_;
	}
	/**
	 * @return
	 */
	public int getPage() {
		return page;
	}
}