/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.core;

import org.eclipse.hyades.uml2sd.ui.drawings.IGC;



/**
 * The base class used for all UML2 graph nodes displayed in the Sequence Diagram SDWidget.
 * 
 * @author sveyrier
 * @version 1.0
 */

public abstract class GraphNode {
	
	/**
	 *  The selection state of the graph node.
	 */
	private boolean selected = false;
	
	/**
	 * The graph node name used to label the graph node in the View.
	 */
	private String 	name	 = ""; //$NON-NLS-1$
	
	/**
	 * Set the graph node name.<br>
	 * It is the name display in the view to label the graph node.
	 * @param the name to set
	 */
	public void setName(String nodeName)
	{
		name = nodeName;
	}

	/**
	 * Returns the graph node name.<br>
	 * It is the name display in the view to label the graph node.
	 * @return the graph node name
	 */
	public String getName()
	{
		return name;
	}
	
	
	/**
	 * Tags the the graph node has selected.<br>
	 * WARNING: This method is only used to draw the 
	 * graph node using the system selection colors. <br>
	 * To use the complete
	 * SDViewer selection mechanism (selection management, notification, etc..)
	 * see SDWidget class
	 * @see org.eclipse.hyades.uml2sd.ui.view.SDWidget#addSelection(GraphNode)
	 * @see org.eclipse.hyades.uml2sd.ui.view.SDWidget#removeSelection(GraphNode)
	 * @see org.eclipse.hyades.uml2sd.ui.view.SDWidget#clearSelection()
	 * @param  selection - true to set selected, false to set unselected
	 */
	public void setSelected(boolean selection)
	{
		selected = selection;
	}
	
	/**
	 * Returns true if the graph node is selected, false otherwise.<br>
	 * The returned value is used to highlight the graph node in the View.
	 * @return true if selected, false otherwise
	 * 
	 */
	public boolean isSelected()
	{
		return selected;
	}
	
	/**
	 * Returns true if the graph node contains the point given in parameter, return false otherwise.
	 * @param	x  the x coordinate of the point to test containment <br>
	 * 			y  the y coordinate of the point to test containment
	 * @return true if contained, false otherwise
	 */
	public boolean contains(int x, int y)
	{
		return false;
	}
	
	/**
	 * Returns the x coordinate of the graph node
	 * @return the x coordinate
	 */
	abstract public int getX();
	
	/**
	 * Returns the y coordinate of the graph node
	 * @return the y coordinate
	 */
	abstract public int getY();
	
	/**
	 * Returns the graph node height
	 * @return the graph node height
	 */
	abstract public int getHeight();
	
	/**
	 * Returns the graph node width
	 * @return the graph node width
	 */
	abstract public int getWidth();
	
	/**
	 * Draws the graph node in the given context
	 * @param context the graphical context to draw in
	 */
	abstract protected void draw(IGC context);
	
	
	
}
