package org.eclipse.hyades.logging.events.cbe;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Configure Situation</b></em>'.
 * <P>
 * The ConfigureSituation deals with the components identifying their 
 * configuration. Any changes that a component makes to its configuration 
 * should be logged using this category. Additionally, messages that describe 
 * current configuration state fall into this category. Existing message 
 * include words like port number is, address is, and process id, for 
 * example: 
 * 
 * <code>ADFS0134I: File transfer is configured with host="9.27.11.13", 
 * port="9090", securityEnabled="false".</code>
 * </P> 
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.ConfigureSituation#getSuccessDisposition <em>Success Disposition</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getConfigureSituation()
 * @model 
 * @generated
 */
public interface ConfigureSituation extends SituationType {
    /**
     * <p>
     * Returns the value of the '<em><b>Success Disposition</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Success Disposition</em>' attribute.
     * @see #setSuccessDisposition(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getConfigureSituation_SuccessDisposition()
     * @model required="true"
     * @generated
     */
    String getSuccessDisposition();

    /**
     * <p>
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.ConfigureSituation#getSuccessDisposition <em>Success Disposition</em>}' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <P>
     * This property specifies whether or not the operation that
     * caused the situation to be reported was successful.
     * The successDisposition is a string with the following set of values:
     * <UL>
     * <LI>SUCCESSFUL</LI>
     * <LI>UNSUCCESSFUL</LI>
     * </UL>
     * </p>
     * <p>
     * This is a <em>required</em> property and once it is set it <em>must not</em> change. 
     * The string length for this property <em>must not</em> exceed 64 characters.
     * </p>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Success Disposition</em>' attribute.
     * @see #getSuccessDisposition()
     * @generated
     */
    void setSuccessDisposition(String value);

	/**
	 * Resets the object's properties to their initial (e.g. null) state.
	 * 
	 * All components are initialized to either zero or null.
	 * 
	 * @since 1.0
	 */
	void init();
} // ConfigureSituation
