package org.eclipse.hyades.logging.events.cbe.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.logging.events.cbe.ContextDataElement;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;
import org.eclipse.hyades.logging.events.cbe.util.EventValidation;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Context Data Element</b></em>'.
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0 
 * @implements Cloneable
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.ContextDataElementImpl#getContextId <em>Context Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.ContextDataElementImpl#getContextValue <em>Context Value</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.ContextDataElementImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.ContextDataElementImpl#getType <em>Type</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ContextDataElementImpl extends SerializableImpl implements ContextDataElement  , Cloneable{

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = 1340201980987934512L;

    /**
     * Classname for trace/log 
     */
    private static final String CLASS_NAME = ContextDataElementImpl.class.getName();

    /**
     * The default value of the '{@link #getContextId() <em>Context Id</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getContextId()
     * @generated
     * @ordered
     */
    protected static final String CONTEXT_ID_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getContextId() <em>Context Id</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getContextId()
     * @generated
     * @ordered
     */
    protected String contextId = CONTEXT_ID_EDEFAULT;

    /**
     * The default value of the '{@link #getContextValue() <em>Context Value</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getContextValue()
     * @generated
     * @ordered
     */
    protected static final String CONTEXT_VALUE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getContextValue() <em>Context Value</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getContextValue()
     * @generated
     * @ordered
     */
    protected String contextValue = CONTEXT_VALUE_EDEFAULT;

    /**
     * The default value of the '{@link #getName() <em>Name</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getName()
     * @generated
     * @ordered
     */
    protected static final String NAME_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getName()
     * @generated
     * @ordered
     */
    protected String name = NAME_EDEFAULT;

    /**
     * The default value of the '{@link #getType() <em>Type</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getType()
     * @generated
     * @ordered
     */
    protected static final String TYPE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getType()
     * @generated
     * @ordered
     */
    protected String type = TYPE_EDEFAULT;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ContextDataElementImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return EventPackage.eINSTANCE.getContextDataElement();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getContextId() {
        return contextId;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setContextId(String newContextId) {
        String oldContextId = contextId;
        contextId = newContextId;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.CONTEXT_DATA_ELEMENT__CONTEXT_ID, oldContextId, contextId));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getContextValue() {
        return contextValue;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setContextValue(String newContextValue) {
        String oldContextValue = contextValue;
        contextValue = newContextValue;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.CONTEXT_DATA_ELEMENT__CONTEXT_VALUE, oldContextValue, contextValue));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getName() {
        return name;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setName(String newName) {
        String oldName = name;
        name = newName;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.CONTEXT_DATA_ELEMENT__NAME, oldName, name));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getType() {
        return type;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setType(String newType) {
        String oldType = type;
        type = newType;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.CONTEXT_DATA_ELEMENT__TYPE, oldType, type));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.CONTEXT_DATA_ELEMENT__CONTEXT_ID :
                return getContextId();
            case EventPackage.CONTEXT_DATA_ELEMENT__CONTEXT_VALUE :
                return getContextValue();
            case EventPackage.CONTEXT_DATA_ELEMENT__NAME :
                return getName();
            case EventPackage.CONTEXT_DATA_ELEMENT__TYPE :
                return getType();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.CONTEXT_DATA_ELEMENT__CONTEXT_ID :
                setContextId((String) newValue);
                return;
            case EventPackage.CONTEXT_DATA_ELEMENT__CONTEXT_VALUE :
                setContextValue((String) newValue);
                return;
            case EventPackage.CONTEXT_DATA_ELEMENT__NAME :
                setName((String) newValue);
                return;
            case EventPackage.CONTEXT_DATA_ELEMENT__TYPE :
                setType((String) newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.CONTEXT_DATA_ELEMENT__CONTEXT_ID :
                setContextId(CONTEXT_ID_EDEFAULT);
                return;
            case EventPackage.CONTEXT_DATA_ELEMENT__CONTEXT_VALUE :
                setContextValue(CONTEXT_VALUE_EDEFAULT);
                return;
            case EventPackage.CONTEXT_DATA_ELEMENT__NAME :
                setName(NAME_EDEFAULT);
                return;
            case EventPackage.CONTEXT_DATA_ELEMENT__TYPE :
                setType(TYPE_EDEFAULT);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.CONTEXT_DATA_ELEMENT__CONTEXT_ID :
                return CONTEXT_ID_EDEFAULT == null ? contextId != null : !CONTEXT_ID_EDEFAULT.equals(contextId);
            case EventPackage.CONTEXT_DATA_ELEMENT__CONTEXT_VALUE :
                return CONTEXT_VALUE_EDEFAULT == null ? contextValue != null : !CONTEXT_VALUE_EDEFAULT.equals(contextValue);
            case EventPackage.CONTEXT_DATA_ELEMENT__NAME :
                return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
            case EventPackage.CONTEXT_DATA_ELEMENT__TYPE :
                return TYPE_EDEFAULT == null ? type != null : !TYPE_EDEFAULT.equals(type);
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy())
            return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (contextId: ");
        result.append(contextId);
        result.append(", contextValue: ");
        result.append(contextValue);
        result.append(", name: ");
        result.append(name);
        result.append(", type: ");
        result.append(type);
        result.append(')');
        return result.toString();
    }

    /**
     * Checks whether the contents of this object conforms to the
     * CBE specification.
     *
     * @throws ValidationException 
     *                       if the object does not follow the 
     *                       CBE specification.
     */
    public void validate() throws ValidationException {

        // checking for required attributes
        EventValidation.validateRequiredProperties(CLASS_NAME, this);

        EAttribute attI = EventPackage.eINSTANCE.getContextDataElement_ContextId();
        EAttribute attV = EventPackage.eINSTANCE.getContextDataElement_ContextValue();
        EAttribute attN = EventPackage.eINSTANCE.getContextDataElement_Name();
        EAttribute attT = EventPackage.eINSTANCE.getContextDataElement_Type();

        // checking for mutually exclusive attributes
        EventValidation.validateMutuallyExclusiveAttributes(CLASS_NAME, this, attI, attV);

        // checking for boundaries
        EventValidation.validateLength(CLASS_NAME, this, attT, 64);
        EventValidation.validateLength(CLASS_NAME, this, attN, 64);
        EventValidation.validateLength(CLASS_NAME, this, attV, 1024);
        EventValidation.validateLength(CLASS_NAME, this, attI, 32, 64);
    }

    /**
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object arg0) {
        return EventHelpers.compareEObject(this, arg0);
    }

	/**
	 * return a cloned (copy by value) object. This is a deep copy version, in which all the
	 * objects within this object will be copied by value.
	 *  
	 * @return Object
	 */
	public Object clone() throws CloneNotSupportedException {
		return EcoreUtil.copy(this);
	}

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    public void init() {

        setContextId(CONTEXT_ID_EDEFAULT);
        setContextValue(CONTEXT_VALUE_EDEFAULT);
        setName(NAME_EDEFAULT);
        setType(TYPE_EDEFAULT);
    }
} //ContextDataElementImpl
