package org.eclipse.hyades.logging.events.cbe.util;

import java.io.Serializable;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.logging.events.cbe.AssociatedEvent;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.AvailableSituation;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ConfigureSituation;
import org.eclipse.hyades.logging.events.cbe.ConnectSituation;
import org.eclipse.hyades.logging.events.cbe.ContextDataElement;
import org.eclipse.hyades.logging.events.cbe.CreateSituation;
import org.eclipse.hyades.logging.events.cbe.DependencySituation;
import org.eclipse.hyades.logging.events.cbe.DestroySituation;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.FeatureSituation;
import org.eclipse.hyades.logging.events.cbe.MsgCatalogToken;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.OtherSituation;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.RequestSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.StartSituation;
import org.eclipse.hyades.logging.events.cbe.StopSituation;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.

 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.logging.events.cbe.EventPackage
 * @generated
 */
public class EventSwitch {

    /**
     * The cached model package
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected static EventPackage modelPackage;

    /**
     * Creates an instance of the switch.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EventSwitch() {
        if (modelPackage == null) {
            modelPackage = EventPackage.eINSTANCE;
        }
    }

    /**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
    public Object doSwitch(EObject theEObject) {
        EClass theEClass = theEObject.eClass();
        if (theEClass.eContainer() == modelPackage) {
            switch (theEClass.getClassifierID()) {
                case EventPackage.ASSOCIATED_EVENT :
                    {
                        AssociatedEvent associatedEvent = (AssociatedEvent) theEObject;
                        Object result = caseAssociatedEvent(associatedEvent);
                        if (result == null)
                            result = caseSerializable(associatedEvent);
                        if (result == null)
                            result = defaultCase(theEObject);
                        return result;
                    }
                case EventPackage.ASSOCIATION_ENGINE :
                    {
                        AssociationEngine associationEngine = (AssociationEngine) theEObject;
                        Object result = caseAssociationEngine(associationEngine);
                        if (result == null)
                            result = caseSerializable(associationEngine);
                        if (result == null)
                            result = defaultCase(theEObject);
                        return result;
                    }
                case EventPackage.AVAILABLE_SITUATION :
                    {
                        AvailableSituation availableSituation = (AvailableSituation) theEObject;
                        Object result = caseAvailableSituation(availableSituation);
                        if (result == null)
                            result = caseSituationType(availableSituation);
                        if (result == null)
                            result = caseSerializable(availableSituation);
                        if (result == null)
                            result = defaultCase(theEObject);
                        return result;
                    }
                case EventPackage.COMMON_BASE_EVENT :
                    {
                        CommonBaseEvent commonBaseEvent = (CommonBaseEvent) theEObject;
                        Object result = caseCommonBaseEvent(commonBaseEvent);
                        if (result == null)
                            result = caseSerializable(commonBaseEvent);
                        if (result == null)
                            result = defaultCase(theEObject);
                        return result;
                    }
                case EventPackage.COMPONENT_IDENTIFICATION :
                    {
                        ComponentIdentification componentIdentification = (ComponentIdentification) theEObject;
                        Object result = caseComponentIdentification(componentIdentification);
                        if (result == null)
                            result = caseSerializable(componentIdentification);
                        if (result == null)
                            result = defaultCase(theEObject);
                        return result;
                    }
                case EventPackage.CONFIGURE_SITUATION :
                    {
                        ConfigureSituation configureSituation = (ConfigureSituation) theEObject;
                        Object result = caseConfigureSituation(configureSituation);
                        if (result == null)
                            result = caseSituationType(configureSituation);
                        if (result == null)
                            result = caseSerializable(configureSituation);
                        if (result == null)
                            result = defaultCase(theEObject);
                        return result;
                    }
                case EventPackage.CONNECT_SITUATION :
                    {
                        ConnectSituation connectSituation = (ConnectSituation) theEObject;
                        Object result = caseConnectSituation(connectSituation);
                        if (result == null)
                            result = caseSituationType(connectSituation);
                        if (result == null)
                            result = caseSerializable(connectSituation);
                        if (result == null)
                            result = defaultCase(theEObject);
                        return result;
                    }
                case EventPackage.CONTEXT_DATA_ELEMENT :
                    {
                        ContextDataElement contextDataElement = (ContextDataElement) theEObject;
                        Object result = caseContextDataElement(contextDataElement);
                        if (result == null)
                            result = caseSerializable(contextDataElement);
                        if (result == null)
                            result = defaultCase(theEObject);
                        return result;
                    }
                case EventPackage.CREATE_SITUATION :
                    {
                        CreateSituation createSituation = (CreateSituation) theEObject;
                        Object result = caseCreateSituation(createSituation);
                        if (result == null)
                            result = caseSituationType(createSituation);
                        if (result == null)
                            result = caseSerializable(createSituation);
                        if (result == null)
                            result = defaultCase(theEObject);
                        return result;
                    }
                case EventPackage.DEPENDENCY_SITUATION :
                    {
                        DependencySituation dependencySituation = (DependencySituation) theEObject;
                        Object result = caseDependencySituation(dependencySituation);
                        if (result == null)
                            result = caseSituationType(dependencySituation);
                        if (result == null)
                            result = caseSerializable(dependencySituation);
                        if (result == null)
                            result = defaultCase(theEObject);
                        return result;
                    }
                case EventPackage.DESTROY_SITUATION :
                    {
                        DestroySituation destroySituation = (DestroySituation) theEObject;
                        Object result = caseDestroySituation(destroySituation);
                        if (result == null)
                            result = caseSituationType(destroySituation);
                        if (result == null)
                            result = caseSerializable(destroySituation);
                        if (result == null)
                            result = defaultCase(theEObject);
                        return result;
                    }
                case EventPackage.EXTENDED_DATA_ELEMENT :
                    {
                        ExtendedDataElement extendedDataElement = (ExtendedDataElement) theEObject;
                        Object result = caseExtendedDataElement(extendedDataElement);
                        if (result == null)
                            result = caseSerializable(extendedDataElement);
                        if (result == null)
                            result = defaultCase(theEObject);
                        return result;
                    }
                case EventPackage.FEATURE_SITUATION :
                    {
                        FeatureSituation featureSituation = (FeatureSituation) theEObject;
                        Object result = caseFeatureSituation(featureSituation);
                        if (result == null)
                            result = caseSituationType(featureSituation);
                        if (result == null)
                            result = caseSerializable(featureSituation);
                        if (result == null)
                            result = defaultCase(theEObject);
                        return result;
                    }
                case EventPackage.MSG_CATALOG_TOKEN :
                    {
                        MsgCatalogToken msgCatalogToken = (MsgCatalogToken) theEObject;
                        Object result = caseMsgCatalogToken(msgCatalogToken);
                        if (result == null)
                            result = caseSerializable(msgCatalogToken);
                        if (result == null)
                            result = defaultCase(theEObject);
                        return result;
                    }
                case EventPackage.MSG_DATA_ELEMENT :
                    {
                        MsgDataElement msgDataElement = (MsgDataElement) theEObject;
                        Object result = caseMsgDataElement(msgDataElement);
                        if (result == null)
                            result = caseSerializable(msgDataElement);
                        if (result == null)
                            result = defaultCase(theEObject);
                        return result;
                    }
                case EventPackage.OTHER_SITUATION :
                    {
                        OtherSituation otherSituation = (OtherSituation) theEObject;
                        Object result = caseOtherSituation(otherSituation);
                        if (result == null)
                            result = caseSituationType(otherSituation);
                        if (result == null)
                            result = caseSerializable(otherSituation);
                        if (result == null)
                            result = defaultCase(theEObject);
                        return result;
                    }
                case EventPackage.REPORT_SITUATION :
                    {
                        ReportSituation reportSituation = (ReportSituation) theEObject;
                        Object result = caseReportSituation(reportSituation);
                        if (result == null)
                            result = caseSituationType(reportSituation);
                        if (result == null)
                            result = caseSerializable(reportSituation);
                        if (result == null)
                            result = defaultCase(theEObject);
                        return result;
                    }
                case EventPackage.REQUEST_SITUATION :
                    {
                        RequestSituation requestSituation = (RequestSituation) theEObject;
                        Object result = caseRequestSituation(requestSituation);
                        if (result == null)
                            result = caseSituationType(requestSituation);
                        if (result == null)
                            result = caseSerializable(requestSituation);
                        if (result == null)
                            result = defaultCase(theEObject);
                        return result;
                    }
                case EventPackage.SITUATION :
                    {
                        Situation situation = (Situation) theEObject;
                        Object result = caseSituation(situation);
                        if (result == null)
                            result = caseSerializable(situation);
                        if (result == null)
                            result = defaultCase(theEObject);
                        return result;
                    }
                case EventPackage.START_SITUATION :
                    {
                        StartSituation startSituation = (StartSituation) theEObject;
                        Object result = caseStartSituation(startSituation);
                        if (result == null)
                            result = caseSituationType(startSituation);
                        if (result == null)
                            result = caseSerializable(startSituation);
                        if (result == null)
                            result = defaultCase(theEObject);
                        return result;
                    }
                case EventPackage.STOP_SITUATION :
                    {
                        StopSituation stopSituation = (StopSituation) theEObject;
                        Object result = caseStopSituation(stopSituation);
                        if (result == null)
                            result = caseSituationType(stopSituation);
                        if (result == null)
                            result = caseSerializable(stopSituation);
                        if (result == null)
                            result = defaultCase(theEObject);
                        return result;
                    }
                default :
                    return defaultCase(theEObject);
            }
        }
        return defaultCase(theEObject);
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Associated Event</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Associated Event</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseAssociatedEvent(AssociatedEvent object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Association Engine</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Association Engine</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseAssociationEngine(AssociationEngine object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Available Situation</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Available Situation</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseAvailableSituation(AvailableSituation object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Common Base Event</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Common Base Event</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseCommonBaseEvent(CommonBaseEvent object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Component Identification</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Component Identification</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseComponentIdentification(ComponentIdentification object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Configure Situation</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Configure Situation</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseConfigureSituation(ConfigureSituation object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Connect Situation</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Connect Situation</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseConnectSituation(ConnectSituation object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Context Data Element</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Context Data Element</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseContextDataElement(ContextDataElement object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Create Situation</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Create Situation</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseCreateSituation(CreateSituation object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Dependency Situation</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Dependency Situation</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseDependencySituation(DependencySituation object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Destroy Situation</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Destroy Situation</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseDestroySituation(DestroySituation object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Extended Data Element</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Extended Data Element</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseExtendedDataElement(ExtendedDataElement object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Feature Situation</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Feature Situation</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseFeatureSituation(FeatureSituation object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Msg Catalog Token</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Msg Catalog Token</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseMsgCatalogToken(MsgCatalogToken object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Msg Data Element</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Msg Data Element</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseMsgDataElement(MsgDataElement object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Other Situation</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Other Situation</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseOtherSituation(OtherSituation object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Report Situation</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Report Situation</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseReportSituation(ReportSituation object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Request Situation</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Request Situation</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseRequestSituation(RequestSituation object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Situation</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Situation</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseSituation(Situation object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Situation Type</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Situation Type</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseSituationType(SituationType object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Start Situation</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Start Situation</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseStartSituation(StartSituation object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Stop Situation</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Stop Situation</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseStopSituation(StopSituation object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Serializable</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Serializable</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseSerializable(Serializable object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>EObject</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch, but this is the last case anyway.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>EObject</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject)
     * @generated
     */
    public Object defaultCase(EObject object) {
        return null;
    }

} //EventSwitch
