/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import java.util.*;

/**
 * An element with differently typed properties.
 * Changing a property sends out a DomainEvent.
 */
public class ProfilingSetElement extends FilterSetElement
{
    private String fDescription;
	private ArrayList fChildren;

		/**
	 * Initialize a new TestElement from the given data.
	 */
	public ProfilingSetElement(String name, String description)
	{
		super(name);
		fDescription = description;
	}

	/**
	 * @return Returns the fDescription.
	 */
	public String getDescription() {
		return fDescription;
	}

	/**
	 * @param description The fDescription to set.
	 */
	public void setDescription(String description) {
		fDescription = description;
	}
	
	public void addChild(ProfilingTypeElement child)
	{
		fChildren.add(child);
	}

}


