/**********************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.http.runner;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.hyades.test.common.util.BaseString;

public class HttpResourceBundle
{
	private static HttpResourceBundle instance;
	private ResourceBundle resourceBundle;

	private HttpResourceBundle()
	{
		try
		{
			resourceBundle = ResourceBundle.getBundle("httpRunner");
		}
		catch(MissingResourceException e)
		{
			e.printStackTrace();
		}
	}

	public static HttpResourceBundle getInstance()
	{
		if (instance == null)
		{
			instance = new HttpResourceBundle();
		}

		return instance;
	}

	public ResourceBundle getResourceBundle()
	{
		return resourceBundle;
	}

	public String getString(String key) throws MissingResourceException
	{
		return resourceBundle.getString(key);
	}

	public String getString(String key, String[] args)
	{
		String value = getString(key);
		if (value == null)
			return null;

		for (int i = 0; i < args.length; i++)
			value = BaseString.replace(value, ("%" + (i + 1)), args[i]);

		return value;
	}
}
