/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.perfmon.xml;

import java.util.Arrays;

public class FastStringBuffer {

	private char value[];
	private int count;

	public FastStringBuffer() {
		this(16);
	}

	public FastStringBuffer(int length) {
		value = new char[length];
	}

	public FastStringBuffer(String str) {
		this(str.length() + 16);
		append(str);
	}

	public int length() {
		return count;
	}

	public int capacity() {
		return value.length;
	}

	private void expandCapacity(int minimumCapacity) {
		int newCapacity = (value.length + 1) * 2;
		if (newCapacity < 0) {
			newCapacity = Integer.MAX_VALUE;
		} else if (minimumCapacity > newCapacity) {
			newCapacity = minimumCapacity;
		}
	
		char newValue[] = new char[newCapacity];
		System.arraycopy(value, 0, newValue, 0, count);
		value = newValue;
	}


	public void setLength(int newLength) {
		if (newLength < 0) {
			throw new StringIndexOutOfBoundsException(newLength);
		}
	
		if (newLength > value.length) {
			expandCapacity(newLength);
		}

		if (count < newLength) {
			Arrays.fill(value,count,value.length,'\0');
		} else {
			count = newLength;
		}
	}

	public char charAt(int index) {
		return value[index];
	}

	public void getChars(int srcBegin, int srcEnd, char dst[], int dstBegin) {
		System.arraycopy(value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
	}

	public void setCharAt(int index, char ch) {
		value[index] = ch;
	}

	public FastStringBuffer append(Object obj) {
		return append(String.valueOf(obj));
	}

	public FastStringBuffer append(String str) {
		if (str == null) {
			str = String.valueOf(str);
		}

		int len = str.length();
		int newcount = count + len;
		if (newcount > value.length)
			expandCapacity(newcount);
		str.getChars(0, len, value, count);
		count = newcount;
		return this;
	}

	public FastStringBuffer append(FastStringBuffer sb) {
		if (sb == null) {
			sb = NULL;
		}

		int len = sb.length();
		int newcount = count + len;
		if (newcount > value.length)
			expandCapacity(newcount);
		sb.getChars(0, len, value, count);
		count = newcount;
		return this;
	}

	private static final FastStringBuffer NULL =  new FastStringBuffer("null");

	public FastStringBuffer append(char str[]) {
		int len = str.length;
		int newcount = count + len;
		if (newcount > value.length)
			expandCapacity(newcount);
		System.arraycopy(str, 0, value, count, len);
		count = newcount;
		return this;
	}

	public FastStringBuffer append(char str[], int offset, int len) {
		int newcount = count + len;
		if (newcount > value.length)
			expandCapacity(newcount);
		System.arraycopy(str, offset, value, count, len);
		count = newcount;
		return this;
	}

	public FastStringBuffer append(boolean b) {
		return append(String.valueOf(b));
	}

	public FastStringBuffer append(char c) {
		int newcount = count + 1;
		if (newcount > value.length)
			expandCapacity(newcount);
		value[count++] = c;
		return this;
	}

	public FastStringBuffer append(int i) {
		return append(String.valueOf(i));
	}

	public FastStringBuffer append(long l) {
		return append(String.valueOf(l));
	}

	public FastStringBuffer append(float f) {
		return append(String.valueOf(f));
	}

	public FastStringBuffer append(double d) {
		return append(String.valueOf(d));
	}

	public FastStringBuffer delete(int start, int end) {
		if (end > count)
			end = count;
	
		int len = end - start;
		if (len > 0) {
			System.arraycopy(value, start+len, value, start, count-end);
			count -= len;
		}
		return this;
	}

	public FastStringBuffer deleteCharAt(int index) {
		System.arraycopy(value, index+1, value, index, count-index-1);
		count--;
		return this;
	}

	public FastStringBuffer replace(int start, int end, String str) {
		if (end > count)
			end = count;

		int len = str.length();
		int newCount = count + len - (end - start);
		if (newCount > value.length)
			expandCapacity(newCount);

		System.arraycopy(value, end, value, start + len, count - end);
		str.getChars(0, len, value, start);
		count = newCount;
		return this;
	}

	public String substring(int start) {
		return substring(start, count);
	}

//	public CharSequence subSequence(int start, int end) {
//		return this.substring(start, end);
//	}

	public String substring(int start, int end) {
		return new String(value, start, end - start);
	}

	public FastStringBuffer insert(int index, char str[], int offset,
																   int len) {
		int newCount = count + len;
		if (newCount > value.length)
			expandCapacity(newCount);
		System.arraycopy(value, index, value, index + len, count - index);
		System.arraycopy(str, offset, value, index, len);
		count = newCount;
		return this;
	}

	public FastStringBuffer insert(int offset, Object obj) {
		return insert(offset, String.valueOf(obj));
	}

	public FastStringBuffer insert(int offset, String str) {
		if (str == null) {
			str = String.valueOf(str);
		}
		int len = str.length();
		int newcount = count + len;
		if (newcount > value.length)
			expandCapacity(newcount);
		System.arraycopy(value, offset, value, offset + len, count - offset);
		str.getChars(0, len, value, offset);
		count = newcount;
		return this;
	}

	public FastStringBuffer insert(int offset, char str[]) {
		int len = str.length;
		int newcount = count + len;
		if (newcount > value.length)
			expandCapacity(newcount);
		System.arraycopy(value, offset, value, offset + len, count - offset);
		System.arraycopy(str, 0, value, offset, len);
		count = newcount;
		return this;
	}

	public FastStringBuffer insert(int offset, boolean b) {
		return insert(offset, String.valueOf(b));
	}

	public FastStringBuffer insert(int offset, char c) {
		int newcount = count + 1;
		if (newcount > value.length)
			expandCapacity(newcount);
		System.arraycopy(value, offset, value, offset + 1, count - offset);
		value[offset] = c;
		count = newcount;
		return this;
	}

	public FastStringBuffer insert(int offset, int i) {
		return insert(offset, String.valueOf(i));
	}

	public FastStringBuffer insert(int offset, long l) {
		return insert(offset, String.valueOf(l));
	}

	public FastStringBuffer insert(int offset, float f) {
		return insert(offset, String.valueOf(f));
	}

	public FastStringBuffer insert(int offset, double d) {
		return insert(offset, String.valueOf(d));
	}

	public int indexOf(char c, int index) {
		for (int i = index; i < count; i++) {
			if (value[i] == c) return i;
		}
		return -1;
	}

	public int indexOf(String str) {
		return indexOf(str, 0);
	}

	private int indexOf(char[] search, int index) {
		int vallen = (count-search.length)+1;
		int match = 0;
		int matchlen = search.length;
		for (int i = index; i < vallen; i++) {

			if (value[i] == search[match]) {
				match++;
				if (match == matchlen) {
					return (i+1)-match;	
				}	
			} else {
				match = 0;
			}	
		}
		return -1;
	}

	private int rindexOf(char[] search, int index) {
		index += search.length-1;
		int slen = search.length-1;
		int match = slen;
		
		for (int i = index; i >= 0; i--) {

			if (value[i] == search[match]) {
				match--;
				if (match == -1) {
					return i;
				}	
			} else {
				match = slen;	
			}		
		}
		return -1;
	}

	public int indexOf(String str, int fromIndex) {
		char[] search = str.toCharArray();
		return indexOf(search,fromIndex);
	}

	public int lastIndexOf(String str) {
		return lastIndexOf(str, count);
	}

	public int lastIndexOf(String str, int fromIndex) {
		char[] search = str.toCharArray();
		return rindexOf(search,fromIndex);
	}

	public FastStringBuffer reverse() {
		int n = count - 1;
		for (int j = (n-1) >> 1; j >= 0; --j) {
			char temp = value[j];
			value[j] = value[n - j];
			value[n - j] = temp;
		}
		return this;
	}

	public String toString() {
		return new String(value,0,count);
	}

}
