/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal;

import org.eclipse.hyades.resources.database.internal.impl.DBVisitorFactoryImpl;
/**
 * This interface lets you create a DBVisitor.
 */
public interface DBVisitorFactory {
	/**
	 * Create a DBVisitor that uses the given database object. The PagingLists
	 * it returns have the given paging size.
	 * 
	 * @param database
	 *            The database object used to get objects from the database
	 * @param pagingSize
	 *            The paging size for the PagingLists returned by the DBVisitor
	 * @return A new DBVisitor object
	 */
	DBVisitor create(Database database, int pagingSize);

	/**
	 * A DBVisitorFactory for you to use.
	 */
	DBVisitorFactory INSTANCE = new DBVisitorFactoryImpl();
} // DBVisitorFactory
