/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
/**
 * A paging list is a list of objects that is stored in a database. The list
 * contains referenced objects for one object and multi-valued reference. The
 * maximum number of objects in memory is determined by the paging size. The
 * PagingList retrieves objects from the database on demand.
 */
public interface PagingList extends List {
	/**
	 * The paging size is the maximum number of objects in memory.
	 * 
	 * @param size
	 */
	void setPagingSize(int size);

	/**
	 * @return The maximum number of objects in memory
	 */
	int getPagingSize();

	/**
	 * Sets the database object that is used to get the objects in the list.
	 * 
	 * @param database
	 */
	void setDatabase(Database database);

	/**
	 * Returns the database object that is used to get the objects in the list.
	 * 
	 * @return
	 */
	Database getDatabase();

	/**
	 * @return The object that has the reference.
	 */
	EObject getObject();

	/**
	 * The reference that the objects in the list are values of.
	 * 
	 * @return
	 */
	EReference getReference();

	/**
	 * Determines whether the objects that are retrieved from the database have
	 * their references set. By default, this is true.
	 */
	void setReferences(boolean setReferences);
} // PagingList
