/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.dbmodel.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.dbmodel.Constraint;
import org.eclipse.hyades.resources.database.internal.dbmodel.DBElement;
import org.eclipse.hyades.resources.database.internal.dbmodel.Database;
import org.eclipse.hyades.resources.database.internal.dbmodel.DbmodelFactory;
import org.eclipse.hyades.resources.database.internal.dbmodel.DbmodelPackage;
import org.eclipse.hyades.resources.database.internal.dbmodel.SQLType;
import org.eclipse.hyades.resources.database.internal.dbmodel.StringType;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class DbmodelFactoryImpl extends EFactoryImpl implements DbmodelFactory {
	/**

	 * Creates and instance of the factory.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public DbmodelFactoryImpl() {
		super();

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case DbmodelPackage.DB_ELEMENT :
				return createDBElement();

			case DbmodelPackage.DATABASE :
				return createDatabase();

			case DbmodelPackage.TABLE :
				return createTable();

			case DbmodelPackage.COLUMN :
				return createColumn();

			case DbmodelPackage.SQL_TYPE :
				return createSQLType();

			case DbmodelPackage.CONSTRAINT :
				return createConstraint();

			case DbmodelPackage.STRING_TYPE :
				return createStringType();

		}

		return null;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public DBElement createDBElement() {
		DBElementImpl dbElement = new DBElementImpl();

		return dbElement;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public Database createDatabase() {
		DatabaseImpl database = new DatabaseImpl();

		return database;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public Table createTable() {
		TableImpl table = new TableImpl();

		return table;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public Column createColumn() {
		ColumnImpl column = new ColumnImpl();

		return column;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public SQLType createSQLType() {
		SQLTypeImpl sqlType = new SQLTypeImpl();

		return sqlType;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public Constraint createConstraint() {
		ConstraintImpl constraint = new ConstraintImpl();

		return constraint;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public StringType createStringType() {
		StringTypeImpl stringType = new StringTypeImpl();

		return stringType;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public DbmodelPackage getDbmodelPackage() {
		return (DbmodelPackage) getEPackage();

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public static DbmodelPackage getPackage() {
		return DbmodelPackage.eINSTANCE;

	}

} //DbmodelFactoryImpl

