/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.dbmodel.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.resources.database.internal.dbmodel.DbmodelPackage;
import org.eclipse.hyades.resources.database.internal.dbmodel.SQLType;
/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>SQL Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.resources.database.internal.dbmodel.impl.SQLTypeImpl#getSqlType <em>Sql Type</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SQLTypeImpl extends DBElementImpl implements SQLType {
	/**

	 * The default value of the '{@link #getSqlType() <em>Sql Type</em>}' attribute.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @see #getSqlType()

	 * @generated

	 * @ordered

	 */

	protected static final int SQL_TYPE_EDEFAULT = 0;

	/**

	 * The cached value of the '{@link #getSqlType() <em>Sql Type</em>}' attribute.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @see #getSqlType()

	 * @generated

	 * @ordered

	 */

	protected int sqlType = SQL_TYPE_EDEFAULT;

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	protected SQLTypeImpl() {
		super();

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	protected EClass eStaticClass() {
		return DbmodelPackage.eINSTANCE.getSQLType();

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public int getSqlType() {
		return sqlType;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public void setSqlType(int newSqlType) {
		int oldSqlType = sqlType;

		sqlType = newSqlType;

		if (eNotificationRequired())

			eNotify(new ENotificationImpl(this, Notification.SET, DbmodelPackage.SQL_TYPE__SQL_TYPE, oldSqlType, sqlType));

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DbmodelPackage.SQL_TYPE__NAME :

				return getName();

			case DbmodelPackage.SQL_TYPE__SQL_TYPE :

				return new Integer(getSqlType());

		}

		return eDynamicGet(eFeature, resolve);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DbmodelPackage.SQL_TYPE__NAME :

				setName((String) newValue);

				return;

			case DbmodelPackage.SQL_TYPE__SQL_TYPE :

				setSqlType(((Integer) newValue).intValue());

				return;

		}

		eDynamicSet(eFeature, newValue);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DbmodelPackage.SQL_TYPE__NAME :

				setName(NAME_EDEFAULT);

				return;

			case DbmodelPackage.SQL_TYPE__SQL_TYPE :

				setSqlType(SQL_TYPE_EDEFAULT);

				return;

		}

		eDynamicUnset(eFeature);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DbmodelPackage.SQL_TYPE__NAME :

				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);

			case DbmodelPackage.SQL_TYPE__SQL_TYPE :

				return sqlType != SQL_TYPE_EDEFAULT;

		}

		return eDynamicIsSet(eFeature);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());

		result.append(" (sqlType: ");

		result.append(sqlType);

		result.append(')');

		return result.toString();

	}

} //SQLTypeImpl

