/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.resources.database.internal.DBResource;
import org.eclipse.hyades.resources.database.internal.DBResourceFactory;
import org.eclipse.hyades.resources.database.internal.Database;
/**
 * This class creates a DBResource.
 */
public class DBResourceFactoryImpl implements DBResourceFactory {
	public DBResourceFactoryImpl() {
		super();
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.DBResourceFactory#createResource(org.eclipse.emf.common.util.URI,
	 *      org.eclipse.hyades.resources.database.internal.Database)
	 */
	public DBResource createResource(URI uri, Database database) {
		return new DBResourceImpl(uri, database);
	}

	/**
	 * @see org.eclipse.emf.ecore.resource.Resource.Factory#createResource(org.eclipse.emf.common.util.URI)
	 */
	public Resource createResource(URI uri) {
		return new DBResourceImpl(uri);
	}

} // DBResourceFactoryImpl
