/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.util.DelegatingEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.loaders.util.IPagingList;
import org.eclipse.hyades.models.hierarchy.extensions.LeftOperand;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.resources.database.internal.DBCollectedExceptions;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.DBCommandFactory;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
/**
 * @author slavescu
 */
public class IndirectedList extends DelegatingEList implements IPagingList {
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.DelegatingEList#delegateList()
	 */
	protected List delegateList() {
		return this;
	}
	protected DBCommandFactory factory;
	protected DBMap dbMap;
	protected DatabaseType type;
	protected WeakObjectCache cache;
	protected JDBCHelper helper;
	protected Query query;
	protected String sqlStatement;
	protected ResourceSet resourceSet;
	protected Collection notLoadedClasses;
	protected ResultSet rs;
	protected int columnPos;
	protected List currentPage;
	protected int currentIndex = -1;
	protected int currentLength = -1;
	protected int size = -1;
	/**
	 *  
	 */
	public IndirectedList(JDBCHelper helper, DBMap dbMap, WeakObjectCache cache, Query query, String sqlStatement, ResourceSet resourceSet, Collection notLoadedClasses, ResultSet rs, int columnPos) {
		super();
		factory = DBCommandFactory.INSTANCE;
		this.helper = helper;
		this.dbMap = dbMap;
		this.cache = cache;
		type = helper.getDatabaseType();
		this.query = query;
		this.sqlStatement = sqlStatement;
		this.resourceSet = resourceSet;
		this.notLoadedClasses = notLoadedClasses;
		this.rs = rs;
		this.columnPos = columnPos;
	}
	private EClass getOutputElementType(LeftOperand oe) {
		if (oe.getFeature() != null) {
			return oe.getFeature().getEContainingClass();
		} else if (oe.getType() != null) {
			return oe.getType();
		}
		return null;
	}
	private void loadPage(int index, int length) {
		PerfUtil p = new PerfUtil("IndirectedList.loadPage() index=" + index + ", length=" + length + ", time1", true);
		try {
			rs.setFetchSize(500);
			if (!rs.absolute(index + 1))
				throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + delegateSize());
			if (((LeftOperand) query.getOutputElements().get(columnPos)).getFeature() != null && ((LeftOperand) query.getOutputElements().get(columnPos)).getFeature().getEType() instanceof EDataType) {
				loadEDataType(index, length, (EDataType) ((LeftOperand) query.getOutputElements().get(columnPos)).getFeature().getEType());
			} else {
				loadEObjects(index, length);
			}
			currentIndex = index;
			currentLength = currentPage.size();
			p.stopAndPrintStatus("currentLength=" + currentLength);
		} catch (Exception e) {
			p.stopAndPrintStatus(e.getLocalizedMessage() + ", " + sqlStatement);
			throw new DBCollectedExceptions(e);
		}
	}
	private void loadEDataType(int index, int length, EDataType t) throws Exception {
		int i = 0;
		currentPage = new ArrayList();
		do {
			i++;
			currentPage.add(EcoreFactory.eINSTANCE.createFromString(t, rs.getString(columnPos + 1)));
		} while (rs.next() && i < length);
	}
	private void loadEObjects(int index, int length) throws Exception {
		List ids = new ArrayList();
		int i = 0;
		PerfUtil p = new PerfUtil("IndirectedList.loadEObjects() index=" + index + ", length=" + ids.size() + ", time1", true);
		do {
			i++;
			try {
				ids.add(new Integer(rs.getInt(columnPos + 1)));
			} catch (Exception e) {
				p.stopAndPrintStatus(e.getLocalizedMessage() + ",i=" + i);
				throw new DBCollectedExceptions(e);
			}
		} while (rs.next() && i < length);
		p.stopAndPrintStatus(",i=" + i);
		p.setMessageAndStart("IndirectedList.loadEObjects() index=" + index + ", length=" + ids.size() + ", time2");
		List classesAndIds = new ArrayList();
		EClass columnClass = getOutputElementType((LeftOperand) query.getOutputElements().get(columnPos));
		classesAndIds.add(columnClass);
		classesAndIds.add(ids);
		//			addNotLoadedClasses();
		DBCommand get = DBCommandFactory.INSTANCE.createGetCommand(helper, dbMap, helper.getDatabaseType(), classesAndIds, true, cache, notLoadedClasses, null);
		currentPage = (List) get.execute();
		p.stopAndPrintStatus("i="+i+",size=" + currentPage.size()+", columnClass="+columnClass+", ids="+ids);
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.DelegatingEList#delegateAdd(int,
	 *      java.lang.Object)
	 */
	protected void delegateAdd(int index, Object object) {
		throw new UnsupportedOperationException();
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.DelegatingEList#delegateAdd(java.lang.Object)
	 */
	protected void delegateAdd(Object object) {
		throw new UnsupportedOperationException();
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.DelegatingEList#delegateBasicList()
	 */
	protected List delegateBasicList() {
		throw new UnsupportedOperationException();
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.DelegatingEList#delegateClear()
	 */
	public void clear() {
		//		size=0;
		//		resourceSet=null;
		//		try {
		//			rs.close();
		//			rs=null;
		//			cache=null;
		//		} catch (Exception e) {
		//			throw new DBCollectedExceptions(e);
		//		}
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.DelegatingEList#delegateContains(java.lang.Object)
	 */
	protected boolean delegateContains(Object object) {
		return delegateIndexOf(object) != -1;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.DelegatingEList#delegateContainsAll(java.util.Collection)
	 */
	protected boolean delegateContainsAll(Collection collection) {
		throw new UnsupportedOperationException();
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.DelegatingEList#delegateEquals(java.lang.Object)
	 */
	protected boolean delegateEquals(Object object) {
		throw new UnsupportedOperationException();
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.DelegatingEList#delegateGet(int)
	 */
	protected Object delegateGet(int index) {
		if (index > delegateSize() - 1) {
			throw new IndexOutOfBoundsException("1> Index: " + index + ", Size: " + delegateSize() + ", CurrentIndex: " + currentIndex + ", CurrentLength: " + currentLength);
		}
		if (currentIndex == -1 || index < currentIndex || index > (currentIndex + currentLength - 1)) {
			loadPage(index, PagingListFactory.INSTANCE.getPagingSize());
		}
		if (index < currentIndex || index > (currentIndex + currentLength - 1)) {
			throw new IndexOutOfBoundsException("2> Index: " + index + ", Size: " + delegateSize() + ", CurrentIndex: " + currentIndex + ", CurrentLength: " + currentLength);
		}
		return currentPage.get(index - currentIndex);
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.DelegatingEList#delegateHashCode()
	 */
	protected int delegateHashCode() {
		return rs != null ? rs.hashCode() : this.hashCode();
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.DelegatingEList#delegateIndexOf(java.lang.Object)
	 */
	protected int delegateIndexOf(Object object) {
		if (object == null)
			return -1;
		return getIndex(object, 0, false);
	}
	/**
	 * @param object
	 * @return @throws
	 *         Exception
	 */
	private int getIndex(Object object, int fromIndex, boolean last) {
		PerfUtil p = new PerfUtil("IndirectedList.getIndex() fromIndex=" + fromIndex + ", last=" + last + ", size=" + delegateSize(), true);
		if (delegateSize() == 0 || fromIndex >= delegateSize()) {
			p.stopAndPrintStatus("return=-1");
			return -1;
		}
		EDataType t = null;
		Object id = null;
		if (((LeftOperand) query.getOutputElements().get(columnPos)).getFeature() != null && ((LeftOperand) query.getOutputElements().get(columnPos)).getFeature().getEType() instanceof EDataType) {
			t = (EDataType) ((LeftOperand) query.getOutputElements().get(columnPos)).getFeature().getEType();
			id = object;
		} else {
			EObject eo = (EObject) object;
			id = cache.getId(eo);
		}
		Object val = null;
		try {
			if (last) {
				int i = (fromIndex == -1 ? delegateSize() - 1 : fromIndex);
				rs.absolute((fromIndex == -1 ? -1 : fromIndex + 1));
				do {
					if (t != null) {
						val = EcoreFactory.eINSTANCE.createFromString(t, rs.getString(columnPos + 1));
					} else {
						val = new Integer(rs.getInt(columnPos + 1));
					}
					if (id.equals(val)) {
						p.stopAndPrintStatus("return=" + i);
						return i;
					}
					i--;
				} while (rs.previous() && i > -1);
			} else {
				rs.absolute(fromIndex + 1);
				int i = fromIndex;
				do {
					if (t != null) {
						val = EcoreFactory.eINSTANCE.createFromString(t, rs.getString(columnPos + 1));
					} else {
						val = new Integer(rs.getInt(columnPos + 1));
					}
					if (id.equals(val)) {
						p.stopAndPrintStatus("return=" + i);
						return i;
					}
					i++;
				} while (rs.next() && i < delegateSize());
			}
		} catch (Exception e) {
			p.stopAndPrintStatus(e.getLocalizedMessage());
			throw new DBCollectedExceptions(e);
		}
		p.stopAndPrintStatus("return=-1");
		return -1;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.DelegatingEList#delegateIsEmpty()
	 */
	protected boolean delegateIsEmpty() {
		return size() == 0;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.DelegatingEList#delegateIterator()
	 */
	protected Iterator delegateIterator() {
		return basicIterator();
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.DelegatingEList#delegateLastIndexOf(java.lang.Object)
	 */
	protected int delegateLastIndexOf(Object object) {
		if (object == null)
			return -1;
		return getIndex(object, -1, true);
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.DelegatingEList#delegateListIterator()
	 */
	protected ListIterator delegateListIterator() {
		throw new UnsupportedOperationException();
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.DelegatingEList#delegateRemove(int)
	 */
	protected Object delegateRemove(int index) {
		throw new UnsupportedOperationException();
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.DelegatingEList#delegateSet(int,
	 *      java.lang.Object)
	 */
	protected Object delegateSet(int index, Object object) {
		throw new UnsupportedOperationException();
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.DelegatingEList#delegateSize()
	 */
	protected int delegateSize() {
		if (size == -1) {
			try {
				if (!rs.absolute(-1))
					size = 0;
				else
					size = rs.getRow();
			} catch (Exception e) {
				size = 0;
				throw new DBCollectedExceptions(e);
			}
		}
		return size;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.DelegatingEList#delegateToArray()
	 */
	protected Object[] delegateToArray() {
		if (size() == 0) {
			return new Object[0];
		}
		loadPage(0, size());
		return currentPage.toArray();
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.DelegatingEList#delegateToArray(java.lang.Object[])
	 */
	protected Object[] delegateToArray(Object[] array) {
		throw new UnsupportedOperationException();
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.DelegatingEList#delegateToString()
	 */
	protected String delegateToString() {
		return this.toString();
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.util.IPagingList#indexOf(java.lang.Object,
	 *      int)
	 */
	public int indexOf(Object object, int fromIndex) {
		if (object == null)
			return -1;
		return getIndex(object, fromIndex, false);
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.util.IPagingList#lastIndexOf(java.lang.Object,
	 *      int)
	 */
	public int lastIndexOf(Object object, int fromIndex) {
		if (object == null)
			return -1;
		return getIndex(object, fromIndex, true);
	}
}