/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.util;

import java.util.Collection;
import java.util.List;
import java.util.Properties;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.Database;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
import org.eclipse.hyades.resources.database.internal.impl.DBCommand;
import org.eclipse.hyades.resources.database.internal.impl.WeakObjectCache;

/**
 * @author slavescu
 */
public interface IDatabaseExtensions {
	String getExtensionName();
	DatabaseType getDBType();
	Database createDatabase(String name, Properties properties);
	String[] getSupportedPostfixes();
	DBCommand createAddCommand(JDBCHelper helper, DBMap map, List objects, WeakObjectCache cache, Resource resource);
	DBCommand createTableCommand(JDBCHelper helper, DBMap map);
	DBCommand createGetCommand(JDBCHelper helper, DBMap map, List classesAndIds, boolean getAllObjects, WeakObjectCache cache, Collection notLoadedClasses, String uri, Resource resource);
	JDBCHelper getJDBCHelper();
}