/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/**
 * Wrapper class used to cache an EObject and one of it's features
 * The class is used to provide features (i.e. child nodes) of CBEDefaultEvent objects 
 * to the log tree viewer and to get the elements (child nodes) of a feature
 * 
 * @see LogContentProvider
 */
public class FeatureNode {
	private EObject element;

	private EStructuralFeature feature;
	/**
	 * Constructor FeatureNode.
	 * @param element the EObject for which we cache the feature
	 * @param feature the cached EStructuralFeature
	 */
	public FeatureNode(EObject element, EStructuralFeature feature) {
		this.element = element;
		this.feature = feature;
	}

	/**
	 * Returns the element.
	 * @return EObject
	 */
	public EObject getElement() {
		return element;
	}

	/**
	 * Returns the feature.
	 * @return EStructuralFeature
	 */
	public EStructuralFeature getFeature() {
		return feature;
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object arg0) {

		if(arg0 instanceof FeatureNode){
			if(((FeatureNode)arg0).getElement().equals(element) && ((FeatureNode)arg0).getFeature().equals(feature)){
				return true;	
			}
			else{
				return false;
			}
		}
		return super.equals(arg0);		
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {

		return feature.hashCode();
	}

}
