/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

import java.text.Collator;
import java.util.Vector;
public class StringSorter
{
   private Collator collator = Collator.getInstance();
   public StringSorter()
   {
   }   
	/**
	*
	* Compares two objects from the vector. Override this method if
	* you want a specialized compare.
	*
	* @param      firstObject  - an Object to be compared
	* @param      secondObject - an Object to be compared
	* @return     the value 0 if the firstObject is equal to the secondObject
	*             a value less than 0 if the firstObject is less than the secondObject
	*             a value greater than 0 if the firstObject is greater than the secondObject
	*/
	public int compare(Object firstObject, Object secondObject)
	{
	   String s1 = firstObject.toString().toLowerCase();
	   String s2 = secondObject.toString().toLowerCase();
	   return collator.compare(s1,s2);
	} 
	  
   // implements a case independant quicksort on a vector of Strings
   public void qsortNoCaseStringVector(Vector v)
   {
	  if(v == null || v.size() < 2)
		return;
	   
	  quickSort(v, 0, v.size() - 1);
   } 
     
   /** This is a generic version of C.A.R Hoare's Quick Sort
	* algorithm.  This will handle arrays that are already
	* sorted, and arrays with duplicate keys.<BR>
	*
	* If you think of a one dimensional array as going from
	* the lowest index on the left to the highest index on the right
	* then the parameters to this function are lowest index or
	* left and highest index or right.  The first time you call
	* this function it will be with the parameters 0, a.length - 1.
	*
	* @param v       a Vector of Objects
	* @param lo0     left boundary of array partition
	* @param hi0     right boundary of array partition
	*/
   void quickSort(Vector v, int lo0, int hi0)
   {
	  int lo = lo0;
	  int hi = hi0;
	  Object mid;

	  if ( hi0 > lo0)
	  {

		 /* Arbitrarily establishing partition element as the midpoint of
		  * the array.
		  */
		 mid = v.elementAt( ( lo0 + hi0 ) / 2 );

		 // loop through the array until indices cross
		 while( lo <= hi )
		 {
			/* find the first element that is greater than or equal to
			 * the partition element starting from the left Index.
			 */
			   while( ( lo < hi0 ) && (compare(v.elementAt(lo),mid)<0) )
					 ++lo;

			/* find an element that is smaller than or equal to
			 * the partition element starting from the right Index.
			 */
			   while( ( hi > lo0 ) && (compare(v.elementAt(hi),mid)>0) )
					 --hi;

			// if the indexes have not crossed, swap
			if( lo <= hi )
			{
			   swap(v, lo, hi);
			   ++lo;
			   --hi;
			}
		 }

		 /* If the right index has not reached the left side of array
		  * must now sort the left partition.
		  */
		 if( lo0 < hi )
			quickSort( v, lo0, hi );

		 /* If the left index has not reached the right side of array
		  * must now sort the right partition.
		  */
		 if( lo < hi0 )
			quickSort( v, lo, hi0 );

	  }
   }   
   private void swap(Vector v, int i, int j)
   {
	  Object T;
	  T = v.elementAt(i);
	  v.setElementAt(v.elementAt(j),i);
	  v.setElementAt(T,j);
   }   
}
