/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.views;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.IRecordPaneViewerListener;
import org.eclipse.hyades.log.ui.internal.util.RecordChangeEvent;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.*;


public class LogPage extends TraceViewerPage implements IRecordPaneViewerListener
{
	protected LogViewerUI _view;
	private Runnable refreshThread = null;

public LogPage(EObject mofObject, TraceViewer _viewer)
{
	super(mofObject, _viewer);
}
/**
 * Insert the method's description here.
 * Creation date: (06/14/2000 12:38:21 PM)
 * @return com.ibm.swt.widgets.Control
 * @param parent com.ibm.swt.widgets.Composite
 */
public void createControl(Composite parent)
{
	_view = new LogViewerUI(parent, this, "was");
	_view.initialize();
	LogUIPlugin.getDefault().addRecordPaneViewerListener(this);	

	makeActions();
}
/**
 * @see IPage#dispose
 */
public void dispose()
{
	LogUIPlugin.getDefault().removeRecordPaneViewerListener(this);	
	super.dispose();
	
	if(_view != null)
	  _view.dispose();
	  	
	_mofObject = null;  
	_view = null;
			  
	
}
/**
 * Returns the SWT control for this page
 *
 * @return the SWT control for this page
 */
public Control getControl() {	
	
	if(_view!=null){
		return _view.getControl();
	}	
	return null;

}
/**
 * Insert the method's description here.
 * Creation date: (1/11/2001 3:12:27 PM)
 * @return com.ibm.etools.trace.views.Histogram
 */
public LogViewerUI getView() {
	return _view;
}
/**
 * Insert the method's description here.
 * Creation date: (1/11/2001 2:54:24 PM)
 */
public void makeActions()
{
	_viewer.makeActions();
}
/**
 * Insert the method's description here.
 * Creation date: (6/5/2001 2:45:25 PM)
 */
public void refreshPage()
{
	getView().refresh();
}
/**
 * Sets focus to a part in the page.
 */
public void setFocus() {
	_view.getControl().setFocus();
}
/**
 * Insert the method's description here.
 * Creation date: (08/14/2000 5:50:25 PM)
 */
public void update(boolean newPage)
{
	if(!newPage){
		_view.refresh();
	}
}

/**
 * Insert the method's description here.
 * Creation date: (6/5/2001 2:45:25 PM)
 */
public void selectionChanged()
{
	getView().selectionChanged();
}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.log.ui.internal.internal.util.IRecordPaneViewerListener#handleRecordChangeEvent(org.eclipse.hyades.log.ui.internal.internal.util.RecordChangeEvent)
	 */
	public void handleRecordChangeEvent(RecordChangeEvent event) {
		if(event.getType()==RecordChangeEvent.FILTER_SEV_CHANGE || event.getType()==RecordChangeEvent.SORT_COL_CHANGE || event.getType()==RecordChangeEvent.FILTER_ADV_CHANGE){	
			if(refreshThread==null){
				refreshThread = new Runnable(){
					public void run() {
						BusyIndicator.showWhile(Display.getDefault(), new Runnable(){
							public void run(){ 
								_view.update();
							}
						});
					};
				};
			}
			Display.getDefault().asyncExec(refreshThread);

		}
				
	}

}
