/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolTable;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDatapoolAction;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

/**
 * @author psun
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class SelectDatapoolInNavigatorAction extends Action implements IDatapoolAction {

	Object[] selectedElements = null;
	DatapoolTable table = null;
	
	public SelectDatapoolInNavigatorAction()
	{
		super(TestUIPlugin.getString("SEL_DP_TEST_NAV_TEXT"));
		setDescription(TestUIPlugin.getString("SEL_DP_TEST_NAV_LDESC"));
	}

	public void run()
	{
		if(table == null)
			return;
		IDatapool datapool = table.getDatapool();
		if(datapool == null)
			return;
		TestNavigator testNavigator = null;
		openView();
		if(PlatformUI.getWorkbench() != null)
		{
			testNavigator = TestNavigator.getTestNavigator(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
		}
		if(testNavigator != null)
		{
			EObject eDatapool = (EObject)datapool;
			testNavigator.getTreeViewer().setSelection(new StructuredSelection(EMFUtil.getWorkspaceFile(eDatapool.eResource())), true);
		}
	}

	public void aboutToShow(boolean bShow)
	{
		setEnabled(bShow);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDatapoolAction#setDatapoolTable(org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolTable)
	 */
	public void setDatapoolTable(DatapoolTable table) 
	{
		this.table = table;
	}	
	
	private void openView() 
	{
		try
		{
			IWorkbenchPage page = TestUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getActivePage();
			if (page != null)
				page.showView(TestNavigator.ID);
		}
		catch (Exception e)
		{
		}		
	}
}
