/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.launch.extensions;

import org.eclipse.core.resources.IContainer;
import org.eclipse.debug.core.ILaunchConfiguration;

/**
 * This interface provides a way to provide the same functionality as 
 * IExecutionHistoryDefaultsProvider does, when the Level 2 extension of
 * the Launch Configuration is used.
 * @author jcanches
 */
public interface IExecutionHistoryDefaultsProvider2 {
	
	/**
	 * Returns the default name for the given Launch Configuration.
	 * @param launchConfiguration
	 * @return The default name for the execution history produced by the execution
	 * of the Launch Configuration.
	 */
	String getDefaultName(ILaunchConfiguration launchConfiguration);
	
	/**
	 * Return the default state for the "Override" check box for the given Launch
	 * Configuration.
	 * Hyades default is false.<br>
	 * State false means that an existing resource with the supplied name will not be
	 * overwritten if it already exists. In that case, a unique name will be generated,
	 * starting with the supplied name.
	 * @param launchConfiguration
	 * @return false for leaving the check box unchecked, true otherwise.
	 */
	boolean getDefaultOverrideState(ILaunchConfiguration launchConfiguration);
	
	/**
	 * Returns the default location for the given Launch Configuration.
	 * @param launchConfiguration
	 * @return The default location for the execution history produced by the execution
	 * of the supplied Launch Configuration. This should be an instance of a Workspace
	 * Project or Folder.
	 */
	IContainer getDefaultLocation(ILaunchConfiguration launchConfiguration);
	
}