/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;


/**
 * @author psun
 *
 */
public class CSVBufferedReader extends BufferedReader {

	private static Character LINEFEED = new Character('\n');
	private static Character DOUBLEQUOTE = new Character('"');
	private static Character CARRIAGERETURN = new Character('\r');
	
	/**
	 * @param in
	 */
	public CSVBufferedReader(Reader in) 
	{
		super(in);
	}
	
	public String readLine() throws IOException
	{
		try
		{
			String line = null;
			boolean keepReading = true;
			boolean inQuoteRegion = false;
			int quoteCount = 0;
			
			int charIntVal = read();
			Character character = null;
			if(charIntVal != -1)
				character = new Character((char)charIntVal);
			while(charIntVal != -1 && keepReading == true)
			{
				
				if(DOUBLEQUOTE.compareTo(character) == 0)
					quoteCount++;

				if(quoteCount == 0 || quoteCount%2 == 0)
					inQuoteRegion = false;
				else
					inQuoteRegion = true;
						
				if(!inQuoteRegion && LINEFEED.compareTo(character) == 0)
					keepReading = false;
					
				if(keepReading)
				{
					if(inQuoteRegion || CARRIAGERETURN.compareTo(character) != 0)
					{	
						if(line == null)
							line = new String();
						line += new String(character.toString());
					}
					charIntVal = read();
					if(charIntVal != -1)
						character = new Character((char)charIntVal);
				}
			}
			
			return line;
		}
		catch(IOException e)
		{
			throw e;
		}
	}	
}
