/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.ui.internal.presentation;

import java.util.Iterator;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.AdapterType;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.LoggingAgentOutputterTypeType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.NotificationOutputterTypeType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterPackage;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.SingleFileOutputterTypeType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.StandardOutOutputterTypeType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.AdapterCBESensorType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorFactory;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPackage;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPropertyType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SingleFileSensorType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.StaticParserSensorType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.ProcessUnitType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.PropertyType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.UnitFactory;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;

/**
 * @author slavescu
  */
public class MigrationUtil {
//	/**
//	 * @param path
//	 */
//	protected boolean migrateFile(IPath path) {
//		AdapterMigrator adapterMigrator = new AdapterMigrator();
//		IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
//		try {
//			
//			return adapterMigrator.migrate(iFile.getLocation().toOSString());
//			
//		} catch (AdapterMigrationException e) {
//			AcadEditorPlugin.INSTANCE.log(e);
//		}
//		return false;
//	}

	/**
	 * @param object
	 * @param string
	 * @return
	 */
	public static PropertyType getOrCreateProperty(ProcessUnitType object, String string) {
		PropertyType propertyType = getProperty(object.getProperty(),string); 
		if(propertyType !=null)
			return propertyType;
		propertyType = UnitFactory.eINSTANCE.createPropertyType();
		propertyType.setPropertyName(string);
		object.getProperty().add(propertyType);
		return propertyType;
	}




	/**
	 * @param object
	 * @return
	 */
	public static Object migrateLoad(AdapterType adapter) {
		if(adapter!= null)
		{
			try {
				adapter.getConfiguration().getContextInstance();
				for (Iterator iter = adapter.getConfiguration().getContextInstance().iterator(); iter.hasNext();) {
					ContextInstanceType contextInstanceType = (ContextInstanceType)iter.next();
					if(contextInstanceType!= null)
					{
						for (Iterator iterator = contextInstanceType.getOutputter().iterator();iterator.hasNext();) {
							OutputterConfigType outputterConfigType = (OutputterConfigType) iterator.next();
							if(outputterConfigType.getSingleFileOutputterType()!=null)
							{
								migrateLoad(outputterConfigType.getSingleFileOutputterType());
							}
							else
							if(outputterConfigType.getLoggingAgentOutputterType()!=null)
							{
								migrateLoad(outputterConfigType.getLoggingAgentOutputterType());
							}
							else
							if(outputterConfigType.getNotificationOutputterType()!=null)
							{
								migrateLoad(outputterConfigType.getNotificationOutputterType());
							}
						}
						if(contextInstanceType.getSensor()!=null) {
							SensorConfigType sensorConfigType = contextInstanceType.getSensor();
							if(sensorConfigType.getSingleFileSensor()!=null)
							{
								migrateLoad(sensorConfigType.getSingleFileSensor());
							}
							else
							if(sensorConfigType.getStaticParserSensor()!=null)
							{
								migrateLoad(sensorConfigType.getStaticParserSensor());
							}
						}
					}
					
				}
			} catch (Exception e) {
				IStatus status = new Status(IStatus.ERROR,AcadEditorPlugin.getDefault().getPluginId(),IStatus.ERROR,AcadEditorPlugin.getDefault().getString("MIGRATION_LOAD_ERROR"),e);
				AcadEditorPlugin.getDefault().logMessage(status);
			}
			
		}
		return adapter;
	}


	public static Object migrateSave(AdapterType adapter) {
		if(adapter != null )
		{

			try {
				adapter.getConfiguration().getContextInstance();
				for (Iterator iter = adapter.getConfiguration().getContextInstance().iterator(); iter.hasNext();) {
					ContextInstanceType contextInstanceType = (ContextInstanceType)iter.next();
					if(contextInstanceType!= null)
					{
						for (Iterator iterator = contextInstanceType.getOutputter().iterator();iterator.hasNext();) {
							OutputterConfigType outputterConfigType = (OutputterConfigType) iterator.next();
							migrateSave(outputterConfigType);
						}
						if(contextInstanceType.getSensor()!=null) {
							SensorConfigType sensorConfigType = contextInstanceType.getSensor();
							migrateSave(sensorConfigType);
						}
					}
					
				}
			} catch (Exception e) {
				IStatus status = new Status(IStatus.ERROR,AcadEditorPlugin.getDefault().getPluginId(),IStatus.ERROR,AcadEditorPlugin.getDefault().getString("MIGRATION_SAVE_ERROR"),e);
				AcadEditorPlugin.getDefault().logMessage(status);
			}
			
		}
		return adapter;
	}


	/**
	 * @param sensorConfigType
	 */
	public static void migrateSave(SensorConfigType sensorConfigType) {
		if(sensorConfigType.getType()==SensorType.SINGLE_FILE_SENSOR_LITERAL)
		{
			SingleFileSensorType type = sensorConfigType.getSingleFileSensor();
			if(type==null)
			{
				type = SensorFactory.eINSTANCE.createSingleFileSensorType();
				sensorConfigType.setSingleFileSensor(type);
			}
			sensorConfigType.setAdapterCBESensor(null);
			sensorConfigType.setStaticParserSensor(null);
			
			type.setDirectory(getPropertyValue(sensorConfigType.getProperty(),SensorPackage.eINSTANCE.getSingleFileSensorType_Directory()));
			type.setFileName(getPropertyValue(sensorConfigType.getProperty(),SensorPackage.eINSTANCE.getSingleFileSensorType_FileName()));
			type.setConverter(getPropertyValue(sensorConfigType.getProperty(),SensorPackage.eINSTANCE.getSingleFileSensorType_Converter()));
			type.setShell(getPropertyValue(sensorConfigType.getProperty(),SensorPackage.eINSTANCE.getSingleFileSensorType_Shell()));
			
		}
		else
		if(sensorConfigType.getType()==SensorType.STATIC_PARSER_SENSOR_LITERAL)
		{
			StaticParserSensorType type = sensorConfigType.getStaticParserSensor();
			if(type==null)
			{
				type = SensorFactory.eINSTANCE.createStaticParserSensorType();
				sensorConfigType.setStaticParserSensor(type);
			}
			sensorConfigType.setAdapterCBESensor(null);
			sensorConfigType.setSingleFileSensor(null);
			
			type.setDirectory(getPropertyValue(sensorConfigType.getProperty(),SensorPackage.eINSTANCE.getStaticParserSensorType_Directory()));
			type.setFileName(getPropertyValue(sensorConfigType.getProperty(),SensorPackage.eINSTANCE.getStaticParserSensorType_FileName()));
			type.setParserClassName(getPropertyValue(sensorConfigType.getProperty(),SensorPackage.eINSTANCE.getStaticParserSensorType_ParserClassName()));
		}
		else
		if(sensorConfigType.getType()==SensorType.ADAPTER_CBE_SENSOR_LITERAL)
		{
			AdapterCBESensorType type = sensorConfigType.getAdapterCBESensor();
			if(type==null)
			{
				type = SensorFactory.eINSTANCE.createAdapterCBESensorType();
				sensorConfigType.setAdapterCBESensor(type);
			}
			sensorConfigType.setStaticParserSensor(null);
			sensorConfigType.setSingleFileSensor(null);
		}
		else
		{
			sensorConfigType.setStaticParserSensor(null);
			sensorConfigType.setSingleFileSensor(null);
			sensorConfigType.setAdapterCBESensor(null);
		}
	}




	/**
	 * @param list
	 * @param attribute
	 * @return
	 */
	public static PropertyType getProperty(EList list, String attribute) {
		for (Iterator iter = list.iterator(); iter.hasNext();) {
			PropertyType element = (PropertyType) iter.next();
			if(element.getPropertyName() != null && element.getPropertyName().equals(attribute))
			{
				return element;
			}
		}
		return null;
	}


	public static String getPropertyValue(EList list, EAttribute attribute) {
		for (Iterator iter = list.iterator(); iter.hasNext();) {
			PropertyType element = (PropertyType) iter.next();
			if(element.getPropertyName() != null && element.getPropertyName().equals(attribute.getName()))
			{
				return element.getPropertyValue();
			}
		}
		return null;
	}


	/**
	 * @param outputterConfigType
	 */
	public static void migrateSave(OutputterConfigType outputterConfigType) {
		if(outputterConfigType.getType()==OutputterType.SINGLE_FILE_OUTPUTTER_LITERAL)
		{
			SingleFileOutputterTypeType type = outputterConfigType.getSingleFileOutputterType();
			if(type==null)
			{
				type = OutputterFactory.eINSTANCE.createSingleFileOutputterTypeType();
				outputterConfigType.setSingleFileOutputterType(type);
			}
			outputterConfigType.setLoggingAgentOutputterType(null);
			outputterConfigType.setNotificationOutputterType(null);
			outputterConfigType.setStandardOutOutputterType(null);
			
			type.setDirectory(getPropertyValue(outputterConfigType.getProperty(),OutputterPackage.eINSTANCE.getSingleFileOutputterTypeType_Directory()));
			type.setFileName(getPropertyValue(outputterConfigType.getProperty(),OutputterPackage.eINSTANCE.getSingleFileOutputterTypeType_FileName()));
			
		}
		else
		if(outputterConfigType.getType()==OutputterType.LOGGING_AGENT_OUTPUTTER_LITERAL)
		{
			LoggingAgentOutputterTypeType type = outputterConfigType.getLoggingAgentOutputterType();
			if(type==null)
			{
				type = OutputterFactory.eINSTANCE.createLoggingAgentOutputterTypeType();
				outputterConfigType.setLoggingAgentOutputterType(type);
			}
			outputterConfigType.setSingleFileOutputterType(null);
			outputterConfigType.setNotificationOutputterType(null);
			outputterConfigType.setStandardOutOutputterType(null);
			
			type.setAgentName(getPropertyValue(outputterConfigType.getProperty(),OutputterPackage.eINSTANCE.getLoggingAgentOutputterTypeType_AgentName()));
			type.setWaitUntilLoggingTime(getPropertyValue(outputterConfigType.getProperty(),OutputterPackage.eINSTANCE.getLoggingAgentOutputterTypeType_WaitUntilLoggingTime()));
			
		}
		else
		if(outputterConfigType.getType()==OutputterType.NOTIFICATION_OUTPUTTER_LITERAL)
		{
			NotificationOutputterTypeType type = outputterConfigType.getNotificationOutputterType();
			if(type==null)
			{
				type = OutputterFactory.eINSTANCE.createNotificationOutputterTypeType();
				outputterConfigType.setNotificationOutputterType(type);
			}
			outputterConfigType.setSingleFileOutputterType(null);
			outputterConfigType.setLoggingAgentOutputterType(null);
			outputterConfigType.setStandardOutOutputterType(null);
			
			type.setResourceURL(getPropertyValue(outputterConfigType.getProperty(),OutputterPackage.eINSTANCE.getNotificationOutputterTypeType_ResourceURL()));
			
		}
		else
		if(outputterConfigType.getType()==OutputterType.SINGLE_FILE_OUTPUTTER_LITERAL)
		{
			StandardOutOutputterTypeType type = outputterConfigType.getStandardOutOutputterType();
			if(type==null)
			{
				type = OutputterFactory.eINSTANCE.createStandardOutOutputterTypeType();
				outputterConfigType.setStandardOutOutputterType(type);
			}

			outputterConfigType.setNotificationOutputterType(null);
			outputterConfigType.setSingleFileOutputterType(null);
			outputterConfigType.setLoggingAgentOutputterType(null);
		}
		else
		{
			outputterConfigType.setNotificationOutputterType(null);
			outputterConfigType.setSingleFileOutputterType(null);
			outputterConfigType.setLoggingAgentOutputterType(null);
			outputterConfigType.setStandardOutOutputterType(null);
		}
	}


	/**
	 * @param type
	 */
	public static void migrateLoad(LoggingAgentOutputterTypeType type) {
		addOrSetProperty(type.eContainer(),OutputterPackage.eINSTANCE.getLoggingAgentOutputterTypeType_AgentName(),type.getAgentName());
		addOrSetProperty(type.eContainer(),OutputterPackage.eINSTANCE.getLoggingAgentOutputterTypeType_WaitUntilLoggingTime(),type.getWaitUntilLoggingTime());
	}



	/**
	 * @param type
	 */
	public static void migrateLoad(NotificationOutputterTypeType type) {
		addOrSetProperty(type.eContainer(),OutputterPackage.eINSTANCE.getNotificationOutputterTypeType_ResourceURL(),type.getResourceURL());
	}



	/**
	 * @param unit
	 * @param attribute
	 * @param string
	 */
	public static void addOrSetProperty(EObject object, EAttribute attribute, String value) {
		addOrSetProperty(object,attribute.getName(),value);
	}




	/**
	 * @param type
	 */
	public static void migrateLoad(SingleFileOutputterTypeType type) {
		addOrSetProperty(type.eContainer(),OutputterPackage.eINSTANCE.getSingleFileOutputterTypeType_Directory(),type.getDirectory());
		addOrSetProperty(type.eContainer(),OutputterPackage.eINSTANCE.getSingleFileOutputterTypeType_FileName(),type.getFileName());
	}




	/**
	 * @param type
	 * @param string
	 * @param string2
	 */
	public static void addOrSetProperty(EObject type, String name, String value) {
		if(value == null)
			return;
		PropertyType propertyType = getOrCreateProperty((ProcessUnitType)type,name);
		propertyType.setPropertyValue(value);
		
	}



	/**
	 * @param type
	 */
	public static void migrateLoad(SingleFileSensorType type) {
		addOrSetProperty(type.eContainer(),SensorPackage.eINSTANCE.getSingleFileSensorType_Directory(),type.getDirectory());
		addOrSetProperty(type.eContainer(),SensorPackage.eINSTANCE.getSingleFileSensorType_FileName(),type.getFileName());
		addOrSetProperty(type.eContainer(),SensorPackage.eINSTANCE.getSingleFileSensorType_Converter(),type.getConverter());
		addOrSetProperty(type.eContainer(),SensorPackage.eINSTANCE.getSingleFileSensorType_Shell(),type.getShell());
	}



	/**
	 * @param type
	 */
	public static void migrateLoad(StaticParserSensorType type) {
		addOrSetProperty(type.eContainer(),SensorPackage.eINSTANCE.getStaticParserSensorType_Directory(),type.getDirectory());
		addOrSetProperty(type.eContainer(),SensorPackage.eINSTANCE.getStaticParserSensorType_FileName(),type.getFileName());
		addOrSetProperty(type.eContainer(),SensorPackage.eINSTANCE.getStaticParserSensorType_ParserClassName(),type.getParserClassName());
		for (Iterator iter = type.getSensorProperty().iterator(); iter.hasNext();) {
			SensorPropertyType element = (SensorPropertyType) iter.next();
			addOrSetProperty(type.eContainer(),element.getPropertyName(),element.getPropertyValue());
		}
	}




}
