/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.internal.collection.framework;

import org.eclipse.hyades.execution.security.IConnectionHandler;
import org.eclipse.hyades.internal.execution.file.IFileServerParameters;

/**
 * @author Giridhar.S
 *
 */
public class FileServerParametersImpl implements IFileServerParameters {

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.file.IFileServerParameters#getConnectionHandler()
	 */
	
	IConnectionHandler connHandler=null;
	private int port;
	
	public IConnectionHandler getConnectionHandler() {
		connHandler=new FileConnectionHandlerImpl();
		return connHandler;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.file.IFileServerParameters#setPort(int)
	 */
	public void setPort(int port) {
		this.port = port;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.file.IFileServerParameters#getPort()
	 */
	public int getPort() {
		return this.port;
	}
}
