/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.test.ui.datapool.internal.control;

import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.hyades.edit.datapool.IDatapoolCell;
import org.eclipse.hyades.edit.datapool.IDatapoolRecord;
import org.eclipse.hyades.test.ui.datapool.internal.util.ValueObject;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

/**
 * @author psun
 *
 */
public class DatapoolClipboard 
{
	private static final String SEPERATOR = "\t"; //$NON-NLS-1$
	private static final String LINEFEED = "\n"; //$NON-NLS-1$
	private static final String CARRIAGERETURN = "\r"; //$NON-NLS-1$
	private static final String CRLF = "\r\n"; //$NON-NLS-1$

	private Vector recordData = null;
	private Vector recordStringData = null;
	private Object cellData = null;
	private Object cellStringData = null;
	private Clipboard clipboard = null;

	private static final DatapoolClipboard instance = new DatapoolClipboard();

	public static DatapoolClipboard getInstance()
	{
		return instance;
	}
	
	protected DatapoolClipboard()
	{
		recordData = new Vector();
		recordStringData = new Vector();
	}
	
	public void addRecordData(IDatapoolRecord record)
	{
		if(record == null)
			return;
		int cellCount = record.getCellCount();
		Object[] valueContent = new Object[cellCount];
		String[] stringContent = new String[cellCount];
		for(int i = 0; i < cellCount; i++)
		{
			IDatapoolCell cell = (IDatapoolCell)record.getCell(i);
			valueContent[i] = cell.getClonedCellValue();
			String cellValue = cell.getPersistedRepresentation();
			stringContent[i] = cellValue;
		}
		recordData.add(valueContent);
		recordStringData.add(stringContent);
	}
	
	public void addCellData(IDatapoolCell cell)
	{
		cellData = cell.getClonedCellValue();
		cellStringData = cell.getPersistedRepresentation();
	}
	
	public Object getCellData()
	{
		TextTransfer transfer = TextTransfer.getInstance();
		String data = (String)clipboard.getContents(transfer);
		if(data.equals(cellStringData))
			return cellData;
		else
			return data;
	}
	
	public Object[] getRecordDataSet()
	{	
		TextTransfer transfer = TextTransfer.getInstance();
		String data = (String)clipboard.getContents(transfer);		

		StringTokenizer dataTokenizer = new StringTokenizer(data, LINEFEED);
		int count = 0;
		boolean isDatapoolData = true;
		while(dataTokenizer.hasMoreTokens())
		{
			String line = dataTokenizer.nextToken();
			if(line.endsWith(CARRIAGERETURN))
				line = line.replaceAll(CARRIAGERETURN, new String());
			Object[] messageElements = {line, LINEFEED};
			line = MessageFormat.format("{0}{1}", messageElements);	//$NON-NLS-1$		
			if(!line.equals(constructClipboardData()[count]))
			{
				isDatapoolData = false;
				break;
			}
			count++;
		}

		if(isDatapoolData)
			return recordData.toArray();

		Vector dataSet = new Vector();		
		StringTokenizer lfTokenizer = new StringTokenizer(data, LINEFEED);
		while(lfTokenizer.hasMoreTokens())
		{
			String line = lfTokenizer.nextToken();
			if(line.endsWith(CARRIAGERETURN))
				line = line.replaceAll(CARRIAGERETURN, new String());
			
			int index = line.indexOf(SEPERATOR);
			int numTokens = 1;
			while(index != -1)
			{
				numTokens++;
				index = line.indexOf(SEPERATOR, index + 1);
			}
				
			String[] cellContents = new String[numTokens];
			count = 0;
			index = line.indexOf(SEPERATOR);
			while(index != -1)
			{
				cellContents[count] = line.substring(0, index);
				line = line.substring(index + 1);
				index = line.indexOf(SEPERATOR);
				count++;
			}
			cellContents[count] = line;
			dataSet.add(cellContents);
		}
		return dataSet.toArray();
	}
	
	public void update()
	{
		TextTransfer transfer = TextTransfer.getInstance();
		if(recordStringData.size() > 0)
		{
			int recordCount = recordStringData.size();
			Transfer[] transfers = new Transfer[recordCount];
			String[] data = constructClipboardData();
			for(int i = 0; i < recordCount; i++)
			{
				transfers[i] = transfer;
			}
			clipboard.setContents(data, transfers);
		}
		else
		{
			Object[] data = {cellData};
			Transfer[] transfers = {transfer};
			clipboard.setContents(data, transfers);
		}
	}
	
	public boolean isEmpty()
	{
		if(recordData != null && !recordData.isEmpty())
			return false;
		if(cellData != null)
			return false;
		TextTransfer transfer = TextTransfer.getInstance();
		if(clipboard != null && transfer != null && !clipboard.isDisposed())
		{
			String data = (String)clipboard.getContents(transfer);
			if(data != null)
				return false;
		}
		return true;
	}
	
	public void clear()
	{
		recordData.clear();
		recordStringData.clear();
		cellData = null;
		cellStringData = null;
	}	
	
	public void setClipboard(Clipboard clipboard)
	{
		if(this.clipboard == null || this.clipboard.isDisposed())
			this.clipboard = clipboard;
	}
	
	private String[] constructClipboardData()
	{
		if(recordStringData.size() > 0)
		{
			int recordCount = recordStringData.size();
			String[] data = new String[recordCount];
			for(int i = 0; i < recordCount; i++)
			{
				Object[] rawRecordData = (Object[])recordStringData.get(i);
				String processedRecordData = new String();
				for(int j = 0; j < rawRecordData.length; j++)
				{
					if(j == 0)
						processedRecordData = (String)rawRecordData[j];
					else
					{
						Object[] messageElements = {processedRecordData, SEPERATOR, (String)rawRecordData[j]};
						processedRecordData = MessageFormat.format("{0}{1}{2}", messageElements); //$NON-NLS-1$
					}
					
				}
				Object[] messageElements = {processedRecordData, LINEFEED};
				processedRecordData = MessageFormat.format("{0}{1}", messageElements); //$NON-NLS-1$
				data[i] = processedRecordData;
			}
			return data;
		}
		else
		{
			String[] data = {new String()};
			return data;
		}
	}
}
