/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.manual.runner.ui.util;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class EditorItem
{
	public final static Integer REFRESH_STATE = new Integer(-123);
	public final static Integer REFRESH = new Integer(-1234);
	
	private Object data;
	private boolean editable;

	public EditorItem()
	{
		this.data = REFRESH;
	}
	
	public EditorItem(Object data, boolean editable)
	{
		this.data = data;
		this.editable = editable;
	}

	public EditorItem(boolean editable)
	{
		this.data = REFRESH_STATE;
		this.editable = editable;
	}
	
	public Object getData()
	{
		return data;
	}

	public boolean isEditable()
	{
		return editable;
	}
}
