/**********************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.http.internal.junit.wizard;

import org.eclipse.hyades.models.common.configuration.CFGInstance;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.java.internal.junit.wizard.RunJavaWizard;

public class HttpRunJavaWizard 
extends RunJavaWizard
{
	
	// Number of users to emulate in a load test scenario
	RunInstancesPage instancesPage = null;
	boolean suiteModified = false;
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.common.internal.wizard.RunWizard#doPerformFinish()
	 */
	public boolean doPerformFinish() {
		// Get the data from the instances page into the suite
		ITestSuite testSuite = getTestSuite();
		
		if (instancesPage != null) {
				CFGInstance instance =
					(CFGInstance) ((TPFTestSuite) getTestSuite()).getInstances().get(0);
				int n = instance.getMaxCount();
				if (n != instancesPage.getNusers()) {
					instance.setMaxCount(instancesPage.getNusers());
					getTest().eResource().setModified(true);
				}
		}

		return super.doPerformFinish();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages() {
		super.addPages();
		instancesPage = createRunInstancesPage();
		this.addPage(instancesPage);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.IWizard#dispose()
	 */
	public void dispose() {
		if (instancesPage != null) {
			instancesPage.dispose();
		}
		
		super.dispose();
	}

	protected RunInstancesPage createRunInstancesPage() {
		// extract the number of users from the test suite to 
		// initialize and determine whether to make the suite dirty
		CFGInstance instance = (CFGInstance) ((TPFTestSuite)getTestSuite()).getInstances().get(0);
		int n = instance.getMaxCount();
		RunInstancesPage page = new RunInstancesPage();
		page.setNusers(n);
		return page;
	}
	
	public ITestSuite getTestSuite() {
		ITestSuite testSuite = null;
		if(getTest() instanceof ITestSuite)
			testSuite = (ITestSuite)getTest();
		else if(getTest() instanceof ITestCase)
			testSuite = ((ITestCase)getTest()).getOwner();

		return testSuite;
	}

}
