/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.preferences;

import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.hyades.log.ui.internal.util.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.preference.*;
import org.eclipse.swt.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.*;
import org.eclipse.ui.help.*;

public class LogAnalyzerFormatPrefPage {

	private Combo dateFormatCombo;
	private Combo timeFormatCombo;
	private IPreferenceStore _preferenceStore;

	public LogAnalyzerFormatPrefPage(IPreferenceStore preferenceStore) {
		super();
		_preferenceStore = preferenceStore;
	}

	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(GridUtil.createHorizontalFill());

		Label description = new Label(composite, SWT.NONE);
		description.setText(
			LogUIPlugin.getResourceString("LOG_ANALYZER_FORMAT_PREF_PAGE_DESCRIPTION"));

		Composite comboComposite = createComboGroup(composite);
		createFormatComboBoxes(comboComposite);

		return composite;
	}
	private Composite createComboGroup(Composite composite) {
		GridLayout layout = new GridLayout();
		layout.horizontalSpacing = 20;
		layout.verticalSpacing = 10;
		layout.numColumns = 2;

		Composite comboComposite = new Composite(composite, SWT.LEFT);
		comboComposite.setLayout(layout);
		comboComposite.setLayoutData(GridUtil.createHorizontalFill());
		return comboComposite;
	}
	private void createFormatComboBoxes(Composite composite) {
		// Create date format combo box.
		Label dateFormatLabel = new Label(composite, SWT.NONE);
		dateFormatLabel.setText(
			LogUIPlugin.getResourceString("LOG_ANALYZER_FORMAT_PREF_PAGE_DATE_FORMAT_LABEL"));
		dateFormatCombo = new Combo(composite, SWT.READ_ONLY);
		dateFormatCombo.setItems(LogUIConstants.LOG_ANALYZER_FORMAT_DATE_LIST);
		dateFormatCombo.setLayoutData(GridUtil.createHorizontalFill());
		// Create time format combo box.
		Label timeFormatLabel = new Label(composite, SWT.NONE);
		timeFormatLabel.setText(
			LogUIPlugin.getResourceString("LOG_ANALYZER_FORMAT_PREF_PAGE_TIME_FORMAT_LABEL"));
		timeFormatCombo = new Combo(composite, SWT.READ_ONLY);
		timeFormatCombo.setItems(LogUIConstants.LOG_ANALYZER_FORMAT_TIME_LIST);
		timeFormatCombo.setLayoutData(GridUtil.createHorizontalFill());

		// Set selection for date format combo box.
		int index =-1;
		String dateFormat = _preferenceStore.getString(LogUIConstants.LOG_ANALYZER_FORMAT_DATE);
		for (int i = 0; i < LogUIConstants.DATE_FORMAT_LIST.length; i++)
			if (dateFormat.equals(LogUIConstants.DATE_FORMAT_LIST[i])) {
				index = i;
				break;
			}

		if (index>-1)
			dateFormatCombo.select(
					index);
		else
			dateFormatCombo.select(0);			

		String timeFormat = _preferenceStore.getString(LogUIConstants.LOG_ANALYZER_FORMAT_TIME);

		index = -1;
		for (int i = 0; i < LogUIConstants.TIME_FORMAT_LIST.length; i++)
			if (timeFormat.equals(LogUIConstants.TIME_FORMAT_LIST[i])) {
				index = i;
				break;
			}

		if (index>-1)
			timeFormatCombo.select(index);
		else
			timeFormatCombo.select(0);


		
//		dateFormatCombo.select(
//			dateFormatCombo.indexOf(
//				_preferenceStore.getString(LogUIConstants.LOG_ANALYZER_FORMAT_DATE)));
		// Set selection for time format combo box.
//		timeFormatCombo.select(
//			timeFormatCombo.indexOf(
//				_preferenceStore.getString(LogUIConstants.LOG_ANALYZER_FORMAT_TIME)));

		WorkbenchHelp.setHelp(dateFormatCombo, ContextIds.ACTLOG_PREF_FORMAT_DATE);
		WorkbenchHelp.setHelp(timeFormatCombo, ContextIds.ACTLOG_PREF_FORMAT_TIME);
	}
	public void init(IWorkbench workbench) {
	}
	protected void performDefaults() {
		//super.performDefaults();

		// Restore default for date format combo box.
		dateFormatCombo.select(
			_preferenceStore.getDefaultInt(LogUIConstants.LOG_ANALYZER_FORMAT_DATE));

		// Restore default for time format combo box.
		timeFormatCombo.select(
			_preferenceStore.getDefaultInt(LogUIConstants.LOG_ANALYZER_FORMAT_TIME));
	}
	public boolean performOk() {
		// Apply selection for date format combo box.
		String selectedDateFormat =
			LogUIConstants.DATE_FORMAT_LIST[dateFormatCombo.getSelectionIndex()];
		boolean dateFmtChanged = false;
		if(!_preferenceStore.getString(LogUIConstants.LOG_ANALYZER_FORMAT_DATE).equals(selectedDateFormat))
		dateFmtChanged = true;

		_preferenceStore.setValue(
			LogUIConstants.LOG_ANALYZER_FORMAT_DATE,
			selectedDateFormat);

		// Apply selection for time format combo box.
		String selectedTimeFormat =
			LogUIConstants.TIME_FORMAT_LIST[timeFormatCombo.getSelectionIndex()];
		
		boolean timeFmtChanged = false;
		if(!_preferenceStore.getString(LogUIConstants.LOG_ANALYZER_FORMAT_TIME).equals(selectedTimeFormat))
			timeFmtChanged = true;

		_preferenceStore.setValue(
			LogUIConstants.LOG_ANALYZER_FORMAT_TIME,
			selectedTimeFormat);

		LogUIPlugin.getDefault().savePluginPreferences();
		if(dateFmtChanged || timeFmtChanged)	
			LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(RecordChangeEvent.PROPERTY_CHANGE, this));
		return true;
	}
}