/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.views;

import java.util.StringTokenizer;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.RecordTableElement;
import org.eclipse.hyades.models.cbe.CBEDefaultEvent;
import org.eclipse.hyades.models.internal.sdb.*;
import org.eclipse.hyades.trace.ui.internal.util.HyperlinkText;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.*;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.PageBook;

public class LogAnalysisPageBook
	extends PageBook
	implements ISelectionChangedListener {

	private CTabFolder tabFolder;
	private CTabItem detailsTabItem, analysisTabItem;
	private HyperlinkText detailsTabText;
	private HyperlinkText analysisTabText;
	private String	resultString="", detailsString="";
	
	private final String LINESEPARATOR = System.getProperty("line.separator");
	private final String DELIMITER =
		"--------------------------------------------------------------------";

	public LogAnalysisPageBook(Composite parent, int style) {
		super(parent, style);
		populateUI();
	}
	public void populateUI() {
				
		tabFolder = new CTabFolder(this, SWT.TOP);

		detailsTabText = new HyperlinkText(tabFolder, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL | SWT.READ_ONLY | SWT.WRAP);
		detailsTabItem = new CTabItem(tabFolder, SWT.NONE);
		detailsTabItem.setText(LogUIPlugin.getResourceString("STR_SYMPTOM_TAB"));
		detailsTabItem.setControl(detailsTabText);

		analysisTabText = new HyperlinkText(tabFolder, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL | SWT.READ_ONLY | SWT.WRAP);
		analysisTabItem = new CTabItem(tabFolder, SWT.NONE);
		analysisTabItem.setText(LogUIPlugin.getResourceString("STR_ANALYSIS_TAB"));
		analysisTabItem.setControl(analysisTabText);

		tabFolder.setSelection(detailsTabItem);
		showPage(tabFolder);		
	}
	
	public void setInputNull() {
		analysisTabText.setText("");
		analysisTabItem.setControl(analysisTabText);

		detailsTabText.setText("");
		detailsTabItem.setControl(detailsTabText);

		tabFolder.setSelection(detailsTabItem);
		showPage(tabFolder);
	}

	public void selectionChanged(SelectionChangedEvent event) {
		Object singleSelection = null;

		ISelection selection = event.getSelection();
		if(!(selection instanceof IStructuredSelection))
			return;
		singleSelection =((IStructuredSelection)selection).getFirstElement();

		if (singleSelection != null) {
			if (singleSelection instanceof CBEDefaultEvent) {
				EList directivesList = ((CBEDefaultEvent) singleSelection).getSymptoms();
				if(directivesList.isEmpty())
					if (((CBEDefaultEvent) singleSelection).isAnalyzed())
						resultString = LogUIPlugin.getResourceString("STR_NO_MATCH");
					else
						resultString = "";
				else
					resultString = formatDirectivesList(directivesList);			
													
			}
			else if(singleSelection instanceof RecordTableElement){

				detailsString = replaceNewLineChars(((RecordTableElement)singleSelection).getValue());
				detailsTabItem.setText(LogUIPlugin.getResourceString("STR_SYMPTOM_TAB")+ " " + ((RecordTableElement)singleSelection).getName() );

			}
			else if(singleSelection instanceof EObject){
				resultString = "";
			}
			else if(singleSelection instanceof Object[]){
				detailsString = "";
				detailsTabItem.setText(LogUIPlugin.getResourceString("STR_SYMPTOM_TAB"));
				resultString = "";			
			}
		}
		
		analysisTabItem.setControl(analysisTabText);		
		analysisTabText.setText(resultString);
		
		detailsTabText.setText(detailsString);
		detailsTabItem.setControl(detailsTabText);

		showPage(tabFolder);
	}
	
	private String formatDirectivesList(EList directivesList) {
		
		StringBuffer analysisBuffer = new StringBuffer();

		for (int idx = 0; idx < directivesList.size(); idx++) {
			analysisBuffer.append(LINESEPARATOR);
			analysisBuffer.append(DELIMITER);
			analysisBuffer.append(LINESEPARATOR);

			SDBSymptom directive = (SDBSymptom) directivesList.get(idx);
			analysisBuffer.append(directive.getDescription())
						  .append(LINESEPARATOR);
			
			//add patterns
			EList list = directive.getPatterns();
			for(int i=0; i<list.size(); i++)
			{
				analysisBuffer.append(((SDBMatchPattern)list.get(i)).getValue())
							  .append(LINESEPARATOR);
			}
			
			//add solutions
			list = directive.getSolutions();
			for(int i=0; i<list.size(); i++)
			{
				SDBSolution sol = (SDBSolution)list.get(i);
				
				analysisBuffer.append(((SDBSolution)list.get(i)).getDescription())
							  .append(LINESEPARATOR);
							  
				EList directives = sol.getDirectives();
				for(int j=0; j<directives.size(); j++)
				{
					analysisBuffer.append(((SDBDirective)directives.get(j)).getDescription())
								  .append(LINESEPARATOR);

				}			  
			}
		}

		return (analysisBuffer.toString().trim());
	}

	private String replaceNewLineChars(String input){
		
		StringBuffer analysisBuffer = new StringBuffer();
		// Replace all new line characters with the system default new line character.
		StringTokenizer tokens = new StringTokenizer(input, "\r\n\f");
		while (tokens.hasMoreTokens()) {
			analysisBuffer.append(tokens.nextToken().trim());
			analysisBuffer.append(LINESEPARATOR);
		}
		
		return analysisBuffer.toString();
		
	}
	
	public void dispose()
	{
		if(analysisTabText != null)
			analysisTabText.dispose();
		if(detailsTabText != null)
			detailsTabText.dispose();
			
	}
	
}
