/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator;

import java.util.Iterator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorProvider;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.model.ui.ITypeProviderFactory;
import org.eclipse.hyades.test.ui.internal.model.ui.VisibleTypes;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

/**
 * @author jgout
 * @author jcanches
 */
public class TestSuiteHTNProvider implements IHyadesTestNavigatorProvider {

	private ITypeProviderFactory typeProvidersFactory;
	
	public TestSuiteHTNProvider() {
		// By default, use providers registered as extensions
		this.typeProvidersFactory = VisibleTypes.getInstance();
	}
	
	public TestSuiteHTNProvider(ITypeProviderFactory factory) {
		this.typeProvidersFactory = factory;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
	 */
	public void dispose() {
		// TODO Auto-generated method stub
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
	 */
	public Object[] getChildren(Object parentElement) 
	{
		if (parentElement instanceof TPFTestSuite) 
		{
			TPFTestSuite ts = (TPFTestSuite) parentElement;
			IHyadesTestNavigatorProvider provider = typeProvidersFactory.getProvider(ts.getType());
			if (provider != null)
				return provider.getChildren(ts);
			//- Default Hyades behavior 
			EList tcs = ts.getTestCases();
			Object[] ret = new Object[tcs.size()];
			int j = 0;
			for (Iterator it = tcs.iterator(); it.hasNext(); j++) 
			{
				ret[j] = (TPFTestCase) it.next();
			}
			return ret;
		}
		return new Object[0];
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	public Object[] getElements(Object inputElement) 
	{
		if (inputElement instanceof TPFTestSuite) 
		{
			TPFTestSuite ts = (TPFTestSuite) inputElement;
			IHyadesTestNavigatorProvider provider = typeProvidersFactory.getProvider(ts.getType());
			if (provider != null)
				return provider.getElements(ts);
		}
		
			//- Default Hyades behavior
			return getChildren(inputElement);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ILabelProvider#getImage(java.lang.Object)
	 */
	public Image getImage(Object element) 
	{
		if (element instanceof TPFTestSuite) 
		{
			TPFTestSuite ts = (TPFTestSuite) element;
			IHyadesTestNavigatorProvider provider = typeProvidersFactory.getProvider(ts.getType());
			if (provider != null)
				return provider.getImage(ts);
			
			//- Default Hyades behavior
			return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_TEST_SUITE);
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
	 */
	public Object getParent(Object element) 
	{
		if (element instanceof TPFTestSuite) 
		{
			TPFTestSuite ts = (TPFTestSuite) element;
			IHyadesTestNavigatorProvider provider = typeProvidersFactory.getProvider(ts.getType());
			if (provider != null) {
				return provider.getParent(ts);
			}
			//- Default Hyades behavior
			EObject parent = ts.eContainer();
			if (parent == null || parent instanceof Resource) {
				// We are at the top of an EMF tree. Convert the EMF Resource to a
				// workspace resource, then get its parent
				Resource res = ts.eResource();
				IFile file = EMFUtil.getWorkspaceFile(res);
				if(file != null) return file.getParent();
			} else {
				return parent;
			}
		}	
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ILabelProvider#getText(java.lang.Object)
	 */
	public String getText(Object element) 
	{
		if (element instanceof TPFTestSuite) {
			TPFTestSuite ts = (TPFTestSuite) element;
			
			IHyadesTestNavigatorProvider provider = typeProvidersFactory.getProvider(ts.getType());
			if (provider != null)
				return provider.getText(ts);
			
			//- Default Hyades behavior
			return ts.getName();
		}
		return ""; //$NON-NLS-1$
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
	 */
	public boolean hasChildren(Object element)  
	{
		if (element instanceof TPFTestSuite) 
		{
			TPFTestSuite ts = (TPFTestSuite) element;
			
			IHyadesTestNavigatorProvider provider = typeProvidersFactory.getProvider(ts.getType());
			if (provider != null)
				return provider.hasChildren(ts);
				
			//- Default Hyades behavior
			return ts.getTestCases().size() > 0;
		}
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		// TODO Auto-generated method stub
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#addListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void addListener(ILabelProviderListener listener) {
		// TODO Auto-generated method stub
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#isLabelProperty(java.lang.Object, java.lang.String)
	 */
	public boolean isLabelProperty(Object element, String property) 
	{
		// TODO Auto-generated method stub
		if (element instanceof TPFTestSuite) 
		{
			TPFTestSuite ts = (TPFTestSuite) element;
			IHyadesTestNavigatorProvider provider = typeProvidersFactory.getProvider(ts.getType());
			if (provider != null)
				return provider.isLabelProperty(ts, property);
		}	
		//- Default Hyades behavior
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#removeListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void removeListener(ILabelProviderListener listener) {
		// TODO Auto-generated method stub
	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.IExecutableExtension#setInitializationData(org.eclipse.core.runtime.IConfigurationElement, java.lang.String, java.lang.Object)
	 */
	public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
	}

	/** This method returns the verdict of the passed element, in this case there is no status
	 * because this is not an execution node.
	 * @param element the element in the Test Navigator
	 * @return  IHyadesTestNavigatorProvider.VERDICT_NONE
	 */
	public int getVerdict(Object element)
	{
		if (element instanceof TPFTestSuite) 
		{
			TPFTestSuite ts = (TPFTestSuite) element;
			IHyadesTestNavigatorProvider provider = typeProvidersFactory.getProvider(ts.getType());
			if (provider != null)
				return provider.getVerdict(ts);
		}	
		//- Default Hyades behavior
		return IHyadesTestNavigatorProvider.VERDICT_NONE;
	}

}
