/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard.selection;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.hyades.ui.internal.wizard.selection.WizardElement;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.graphics.Image;

/**
 * This class implements a wizard for the selection or creation of resources with a certain file extension
 * in the workspace.
 *  
 * @author bjiang
 * @since  1.3
 */
public class ResourceSelectionWizard extends HyadesWizard
{
	private WizardResourceSelectionPage fileSelectionPage;
	private WizardElement newFileWizardElement;
	private String fileExtension;
	private Image fileImage;
	private EObject[] selectedEObjects;
	
	public ResourceSelectionWizard(WizardElement newFileWizardElement, String fileExtension, Image fileImage)
	{
		this.newFileWizardElement = newFileWizardElement;
		this.fileExtension = fileExtension;
		this.fileImage = fileImage;
		setForcePreviousAndNextButtons(true);
	}
	
	/**
	 * Returns the selection page.
	 * @return SelectionPage
	 */
	protected WizardResourceSelectionPage getSelectionPage()
	{
		return fileSelectionPage;
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesWizard#initPages()
	 */
	protected void initPages()
	{
		fileSelectionPage = new WizardResourceSelectionPage("fileSelectionPage", getWorkbench(), getSelection(), fileExtension, fileImage, newFileWizardElement);
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
		addPage(getSelectionPage());
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.IWizard#performFinish()
	 */
	public boolean performFinish()
	{
		selectedEObjects = getSelectionPage().getSelectedEObjects();	
		if(selectedEObjects == null || selectedEObjects.length == 0)
		{
			IWizard newWizard = getSelectionPage().getNewFileWizardNode().getWizard();
			if(newWizard instanceof HyadesNewWizard)
			{
				IFile newFile = ((HyadesNewWizard)newWizard).getNewFile();
				URI uri = URI.createPlatformResourceURI(newFile.getFullPath().toString());
				selectedEObjects = EMFUtil.getEObjects(uri, true);
			}	
		}
		return true;
	}
	
	public EObject[] getSelectedEObjects()
	{
		if(selectedEObjects == null)
			selectedEObjects = new EObject[0];
			
		return this.selectedEObjects;
	}
	
}
