/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.launch.tabGroups;

import java.util.List;

/**
 * This class provides the TabGroup for the basic Hyades Test Launch Configurations.
 * It consists of a Test Selection Tab, plus the standard Hyades Tabs ([Profiling],
 * Test Execution History, Common).
 * Sub-classes may add additional tabs after the Test Selection Tab by overriding
 * the method <code>addAdditionalTabs(List tabList)</code>.
 * @see org.eclipse.hyades.test.ui.launch.tabGroups.AbstractTabGroup
 * @author jcanches
 */
public class BasicTestTabGroup extends AbstractTabGroup {

	/**
	 * Add to the tab list the Hyades Test Selection Tab.
	 * @param tabList
	 */
	protected void addRunnableItemSelectionTab(List tabList, String mode) {
		addTestAndDeploymentTab(tabList, mode);
	}
	
	/**
	 * Add to the tab list any additional tab.
	 * This method should be sub-classed to provide additional tabs. These tabs
	 * are inserted before the Profiling tab (if any) or the Common tab.
	 * @param tabList
	 */
	protected void addAdditionalTabs(List tabList, String mode) {
		// The basic Launch Configuration does not provide additional tabs.
	}
	
	protected String getLaunchConfigurationType() {
		return null; // means use basic Launch Configuration Type
	}
}
