/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import java.util.Comparator;

import org.eclipse.hyades.uml2sd.trace.selection.IDateSelection;

/**
 * This class is intended to compare DateSelection items
 */
public class DateComparator implements Comparator {
	

	public int compare(Object arg0, Object arg1) {
	if (arg0 instanceof IDateSelection && arg1 instanceof IDateSelection)
	{
		IDateSelection t1 = (IDateSelection)arg0;
		IDateSelection t2 = (IDateSelection)arg1;
		if (t1.getStartDate()>t2.getStartDate())
			return 1;
		else if (t1.getStartDate() == t2.getStartDate())
			return 0;
		else return -1;
	}
	else return 0;
}

}
