/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.extensions.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage;
import org.eclipse.hyades.models.hierarchy.extensions.InstanceQuery;
import org.eclipse.hyades.models.hierarchy.extensions.LeftOperand;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Simple Binary Expression</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleBinaryExpressionImpl#getRightOperand <em>Right Operand</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleBinaryExpressionImpl#getOperator <em>Operator</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleBinaryExpressionImpl#getSearchQuery <em>Search Query</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleBinaryExpressionImpl#getInstanceQuery <em>Instance Query</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleBinaryExpressionImpl#getOperand <em>Operand</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SimpleBinaryExpressionImpl extends EObjectImpl implements SimpleBinaryExpression {
	/**
	 * The default value of the '{@link #getRightOperand() <em>Right Operand</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRightOperand()
	 * @generated
	 * @ordered
	 */
	protected static final Object RIGHT_OPERAND_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getRightOperand() <em>Right Operand</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRightOperand()
	 * @generated
	 * @ordered
	 */
	protected Object rightOperand = RIGHT_OPERAND_EDEFAULT;

	/**
	 * The default value of the '{@link #getOperator() <em>Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperator()
	 * @generated
	 * @ordered
	 */
	protected static final RelationalOperators OPERATOR_EDEFAULT = RelationalOperators.LT_LITERAL;

	/**
	 * The cached value of the '{@link #getOperator() <em>Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperator()
	 * @generated
	 * @ordered
	 */
	protected RelationalOperators operator = OPERATOR_EDEFAULT;

	/**
	 * The cached value of the '{@link #getOperand() <em>Operand</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperand()
	 * @generated
	 * @ordered
	 */
	protected LeftOperand operand = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SimpleBinaryExpressionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ExtensionsPackage.eINSTANCE.getSimpleBinaryExpression();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getRightOperand() {
		return rightOperand;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRightOperand(Object newRightOperand) {
		Object oldRightOperand = rightOperand;
		rightOperand = newRightOperand;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__RIGHT_OPERAND, oldRightOperand, rightOperand));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RelationalOperators getOperator() {
		return operator;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOperator(RelationalOperators newOperator) {
		RelationalOperators oldOperator = operator;
		operator = newOperator == null ? OPERATOR_EDEFAULT : newOperator;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__OPERATOR, oldOperator, operator));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SimpleSearchQuery getSearchQuery() {
		if (eContainerFeatureID != ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__SEARCH_QUERY) return null;
		return (SimpleSearchQuery)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSearchQuery(SimpleSearchQuery newSearchQuery) {
		if (newSearchQuery != eContainer || (eContainerFeatureID != ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__SEARCH_QUERY && newSearchQuery != null)) {
			if (EcoreUtil.isAncestor(this, newSearchQuery))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newSearchQuery != null)
				msgs = ((InternalEObject)newSearchQuery).eInverseAdd(this, ExtensionsPackage.SIMPLE_SEARCH_QUERY__WHERE_EXPRESSIONS, SimpleSearchQuery.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newSearchQuery, ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__SEARCH_QUERY, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__SEARCH_QUERY, newSearchQuery, newSearchQuery));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InstanceQuery getInstanceQuery() {
		if (eContainerFeatureID != ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__INSTANCE_QUERY) return null;
		return (InstanceQuery)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInstanceQuery(InstanceQuery newInstanceQuery) {
		if (newInstanceQuery != eContainer || (eContainerFeatureID != ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__INSTANCE_QUERY && newInstanceQuery != null)) {
			if (EcoreUtil.isAncestor(this, newInstanceQuery))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newInstanceQuery != null)
				msgs = ((InternalEObject)newInstanceQuery).eInverseAdd(this, ExtensionsPackage.INSTANCE_QUERY__CONDITIONS, InstanceQuery.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newInstanceQuery, ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__INSTANCE_QUERY, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__INSTANCE_QUERY, newInstanceQuery, newInstanceQuery));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LeftOperand getOperand() {
		if (operand != null && operand.eIsProxy()) {
			LeftOperand oldOperand = operand;
			operand = (LeftOperand)eResolveProxy((InternalEObject)operand);
			if (operand != oldOperand) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__OPERAND, oldOperand, operand));
			}
		}
		return operand;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LeftOperand basicGetOperand() {
		return operand;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOperand(LeftOperand newOperand) {
		LeftOperand oldOperand = operand;
		operand = newOperand;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__OPERAND, oldOperand, operand));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__SEARCH_QUERY:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__SEARCH_QUERY, msgs);
				case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__INSTANCE_QUERY:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__INSTANCE_QUERY, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__SEARCH_QUERY:
					return eBasicSetContainer(null, ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__SEARCH_QUERY, msgs);
				case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__INSTANCE_QUERY:
					return eBasicSetContainer(null, ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__INSTANCE_QUERY, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__SEARCH_QUERY:
					return ((InternalEObject)eContainer).eInverseRemove(this, ExtensionsPackage.SIMPLE_SEARCH_QUERY__WHERE_EXPRESSIONS, SimpleSearchQuery.class, msgs);
				case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__INSTANCE_QUERY:
					return ((InternalEObject)eContainer).eInverseRemove(this, ExtensionsPackage.INSTANCE_QUERY__CONDITIONS, InstanceQuery.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__RIGHT_OPERAND:
				return getRightOperand();
			case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__OPERATOR:
				return getOperator();
			case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__SEARCH_QUERY:
				return getSearchQuery();
			case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__INSTANCE_QUERY:
				return getInstanceQuery();
			case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__OPERAND:
				if (resolve) return getOperand();
				return basicGetOperand();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__RIGHT_OPERAND:
				setRightOperand((Object)newValue);
				return;
			case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__OPERATOR:
				setOperator((RelationalOperators)newValue);
				return;
			case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__SEARCH_QUERY:
				setSearchQuery((SimpleSearchQuery)newValue);
				return;
			case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__INSTANCE_QUERY:
				setInstanceQuery((InstanceQuery)newValue);
				return;
			case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__OPERAND:
				setOperand((LeftOperand)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__RIGHT_OPERAND:
				setRightOperand(RIGHT_OPERAND_EDEFAULT);
				return;
			case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__OPERATOR:
				setOperator(OPERATOR_EDEFAULT);
				return;
			case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__SEARCH_QUERY:
				setSearchQuery((SimpleSearchQuery)null);
				return;
			case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__INSTANCE_QUERY:
				setInstanceQuery((InstanceQuery)null);
				return;
			case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__OPERAND:
				setOperand((LeftOperand)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__RIGHT_OPERAND:
				return RIGHT_OPERAND_EDEFAULT == null ? rightOperand != null : !RIGHT_OPERAND_EDEFAULT.equals(rightOperand);
			case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__OPERATOR:
				return operator != OPERATOR_EDEFAULT;
			case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__SEARCH_QUERY:
				return getSearchQuery() != null;
			case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__INSTANCE_QUERY:
				return getInstanceQuery() != null;
			case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__OPERAND:
				return operand != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (rightOperand: ");
		result.append(rightOperand);
		result.append(", operator: ");
		result.append(operator);
		result.append(')');
		return result.toString();
	}

} //SimpleBinaryExpressionImpl
