/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;


public class TraceProfileTypeGroupUI
{
	
	private Label _name;
	private Label _description;
/**
 * TraceOptionsUI constructor comment.
 */
public TraceProfileTypeGroupUI() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (4/26/2001 3:45:54 PM)
 * @param parent com.ibm.swt.widgets.Composite
 */
public Composite createControl(Composite parent, String name, String description)
{
	GridLayout layout;
	GridData   data;
	
	Composite result = new Composite(parent, SWT.NULL);
	layout = new GridLayout();
	result.setLayout(layout);
	data = GridUtil.createHorizontalFill();
	data.heightHint = 300;
	data.widthHint = 400;
	result.setLayoutData(data);

	_name = new Label(result, SWT.NULL);
	_name.setText(name);
	Font font = _name.getFont();
	if (font != null) {
		FontData[] fonts = font.getFontData();
		if (fonts != null && fonts.length >= 1) {
			_name.setFont(new Font(Display.getDefault(), fonts[0].getName(), fonts[0].getHeight() + 3, SWT.BOLD));
		}
	}

	_description = new Label(result, SWT.WRAP);
	_description.setText(description);
	data = new GridData();
	data.horizontalIndent = 20;
	data.widthHint = 375;
	_description.setLayoutData(data);
	
	return result;
}


	/**
	 * @return Returns the _description.
	 */
	public String getDescription() {
		return _description.getText();
	}
	/**
	 * @param _description The _description to set.
	 */
	public void setDescription(String description) {
		_description.setText(description);
	}
	/**
	 * @return Returns the _name.
	 */
	public String getName() {
		return _name.getText();
	}
	/**
	 * @param _name The _name to set.
	 */
	public void setName(String name) {
		_name.setText(name);
	}
	/**
	 * @return Returns the _description.
	 */
	public Label getDescriptionLabel() {
		return _description;
	}
	/**
	 * @return Returns the _name.
	 */
	public Label getNameLabel() {
		return _name;
	}
}
