/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.common;

import java.util.List;
import java.util.StringTokenizer;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictReason;
import org.eclipse.hyades.models.common.testprofile.impl.Common_TestprofileFactoryImpl;

/**
 * @author amathur
 *
 * This is a verdict event loader
 */
public class XMLverdictEventLoader extends XMLexecutionEventLoader {
	// Static variables
	protected final static String EVENT_VERDICT_VERDICT = "verdict";
	protected final static String EVENT_VERDICT_REASON = "reason";
	protected final static String EVENT_VERDICT_CAUSEDBY = "causedBy";
	
	// Attribute variables
	protected TPFVerdict verdict = null;
	protected TPFVerdictReason verdictReason = null;
	protected String causedBy = null;

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
	 */
	public void initialize(HierarchyContext context, String name) {
		super.initialize(context, name);
		verdict = null;
		verdictReason = null;
		causedBy = null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addAttribute(java.lang.String, java.lang.String)
	 */
	public void addAttribute(String name, String value) {
		printAttribute(name, value);
		switch (LoadersUtils.getHashCode(name)) {
		case ExecutionConstants.EVENT_VERDICT_VERDICT_int :
			verdict = TPFVerdict.get(Integer.parseInt(value));
			break;
			
		case ExecutionConstants.EVENT_VERDICT_REASON_int :
			verdictReason = TPFVerdictReason.get(Integer.parseInt(value));
			break;
			
		case ExecutionConstants.EVENT_VERDICT_CAUSEDBY_int :
			causedBy = value;
			break;

		default:
			super.addAttribute(name, value);
			break;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addYourselfInContext()
	 */
	public void addYourselfInContext() {
		// Create the event
		TPFVerdictEvent verdictEvent = Common_TestprofileFactoryImpl.eINSTANCE.createTPFVerdictEvent();
		
		// Now populate the specialized attributes
		verdictEvent.setVerdict(verdict);
		verdictEvent.setReason(verdictReason);
		
		// populate the event with the base event attributes
		event = (TPFExecutionEvent) verdictEvent;
		super.addYourselfInContext();
		super.addYourselfToContainer();

		// (Only do this if we are using the new XML fragment structure -- if we're
		// using the old structure, then the causedBy relationship will never be
		// populated.) 
		if ( parentId != null )
		{
			// Now fix up relationships that are specific to this type of execution event.
			TPFExecutionResult containingResult = 
				ExecutionResultData.getContainingResult(event);
			containingResult.setVerdict(((TPFVerdictEvent) event).getVerdict());
		
			if ( causedBy != null )
			{
				StringTokenizer tok = new StringTokenizer(causedBy, ",");
				List causedBy = verdictEvent.getCausedBy();
			
				while (tok.hasMoreElements())
				{
					String causeId = tok.nextToken();
					TPFVerdictEvent cause = (TPFVerdictEvent)verdictEvent.eResource().getEObject(causeId); 
					if ( cause != null )
					{
						causedBy.add(cause);
					}
				}
			}
		}
	}
	
	/**
	 * @see org.eclipse.hyades.loaders.common.XMLexecutionEventLoader#needOverwrite(org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent)
	 */
	protected boolean needOverwrite(TPFExecutionEvent match) {
		// @akmathur: In the future we may have other criteria that make sense to
		// determine if we should overwrite a verdict event or not. One such 
		// criteria could be "If-worse-verdict"
		return super.needOverwrite(match);
	}

	/**
	 * @see org.eclipse.hyades.loaders.common.XMLexecutionEventLoader#overwrite(org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent)
	 */
	protected void overwrite(TPFExecutionEvent match) {
		super.overwrite(match);
		((TPFVerdictEvent)match).setVerdict(((TPFVerdictEvent) event).getVerdict());
		((TPFVerdictEvent)match).setReason(((TPFVerdictEvent) event).getReason());
	}
}
