/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.datapool.impl;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolSuggestedType;
import org.eclipse.hyades.execution.runtime.datapool.DatapoolException;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolIterator;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolFactory;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage;
import org.eclipse.hyades.models.common.datapool.DPLCell;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.DPLDatapoolSpec;
import org.eclipse.hyades.models.common.datapool.DPLEquivalenceClass;
import org.eclipse.hyades.models.common.datapool.DPLRecord;
import org.eclipse.hyades.models.common.datapool.DPLRole;
import org.eclipse.hyades.models.common.datapool.DPLVariable;

//import org.eclipse.hyades.models.common.facades.behavioral.impl.FacadeResourceFactoryImpl;
//import org.eclipse.hyades.models.common.testprofile.impl.Common_TestprofilePackageImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class Common_DatapoolFactoryImpl extends EFactoryImpl 
              implements Common_DatapoolFactory {
              	
    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public static final String copyright = ""; //$NON-NLS-1$

    //cached datapools          	
    private static java.util.HashMap datapoolsOpen = new java.util.HashMap();
    
    //reference counters for cached datapools
    private static java.util.HashMap datapoolRefCounts = new java.util.HashMap();           	
              	
              	
    /**
     * Creates and instance of the factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Common_DatapoolFactoryImpl()
    {
        super();
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EObject create(EClass eClass)
    {
        switch (eClass.getClassifierID())
        {
            case Common_DatapoolPackage.DPL_DATAPOOL_SPEC: return createDPLDatapoolSpec();
            case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS: return createDPLEquivalenceClass();
            case Common_DatapoolPackage.DPL_RECORD: return createDPLRecord();
            case Common_DatapoolPackage.DPL_CELL: return createDPLCell();
            case Common_DatapoolPackage.DPL_VARIABLE: return createDPLVariable();
            case Common_DatapoolPackage.DPL_DATAPOOL: return createDPLDatapool();
            default:
                throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier"); //$NON-NLS-1$ //$NON-NLS-2$
        }
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Object createFromString(EDataType eDataType, String initialValue)
    {
        switch (eDataType.getClassifierID())
        {
            case Common_DatapoolPackage.DPL_ROLE:
                return DPLRole.get(initialValue);
            default:
                throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier"); //$NON-NLS-1$ //$NON-NLS-2$
        }
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public String convertToString(EDataType eDataType, Object instanceValue)
    {
        switch (eDataType.getClassifierID())
        {
            case Common_DatapoolPackage.DPL_ROLE:
                return instanceValue == null ? null : instanceValue.toString();
            default:
                throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier"); //$NON-NLS-1$ //$NON-NLS-2$
        }
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public DPLDatapoolSpec createDPLDatapoolSpec()
    {
        DPLDatapoolSpecImpl dplDatapoolSpec = new DPLDatapoolSpecImpl();
        return dplDatapoolSpec;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public DPLDatapool createDPLDatapool()
    {
        DPLDatapoolImpl dplDatapool = new DPLDatapoolImpl();
        return dplDatapool;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public DPLEquivalenceClass createDPLEquivalenceClass()
    {
        DPLEquivalenceClassImpl dplEquivalenceClass = new DPLEquivalenceClassImpl();
        return dplEquivalenceClass;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public DPLRecord createDPLRecord()
    {
        DPLRecordImpl dplRecord = new DPLRecordImpl();
        return dplRecord;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public DPLCell createDPLCell()
    {
        DPLCellImpl dplCell = new DPLCellImpl();
        return dplCell;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public DPLVariable createDPLVariable()
    {
        DPLVariableImpl dplVariable = new DPLVariableImpl();
        return dplVariable;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Common_DatapoolPackage getCommon_DatapoolPackage()
    {
        return (Common_DatapoolPackage)getEPackage();
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @deprecated
     * @generated
     */
	public static Common_DatapoolPackage getPackage()
    {
        return Common_DatapoolPackage.eINSTANCE;
    }
	//Beginning of non-generated classes
	
//	static {
		//Initialize our EMF models.
//		Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("datapool", new FacadeResourceFactoryImpl()); 
//	    Common_TestprofilePackageImpl.init();
//	}
	
	//org.eclipse.hyades.edit.datapool.IDatapoolFactory methods
	
	/**
	 * Load the datapool from the specified file.  If a
	 * <code>sharedInstance</code> is requested then the cache of
	 * other datapools that have been opened is checked for an 
	 * existing copy of the datapool.  Note that modifying a shared
	 * instance of the datapool may effect other uses of the datapool
	 * and should only be done in a confined execution environment.
	 * 
	 * @param	dpFile			The datapool file name.
	 * @param	sharedInstance	Available for sharing instances of
	 *						the datapool, which can save significantly 
	 *						on datapool loading overhead.
	 * 
	 * @see	#unload(IDatapool)
	 */
	public IDatapool loadForEdit(java.io.File dpFile, boolean sharedInstance)
	{

		synchronized(this)  // TEST&SET  
		{		
			String dpAbsolutePath = dpFile.getAbsolutePath();
			IDatapool dp = (IDatapool)datapoolsOpen.get(dpAbsolutePath);
	
			if (!sharedInstance  || (sharedInstance && dp == null))
			{
				//private instance requested, or shared and isn't yet loaded
				try {
	
					ResourceSet resourceSet = new ResourceSetImpl();
					DPLLogImpl.log("Load file: " + dpAbsolutePath);	 //$NON-NLS-1$
					Resource res = resourceSet.getResource(URI.createFileURI(dpAbsolutePath), true);
					res.load(null);
					IDatapool datapool = (IDatapool)res.getContents().get(0);
					if (sharedInstance)
					{ 
						//cache datapool
						datapoolsOpen.put(dpAbsolutePath, datapool);
						DPLLogImpl.log("datapool cached, refCount =1"); //$NON-NLS-1$
						datapoolRefCounts.put(dpAbsolutePath, new Integer(1));
					}
					((DPLDatapoolImpl)datapool).setAbsoluteFilePathname(dpAbsolutePath);
					return datapool;
			    
				}
				catch (Throwable t)
				{
					throw new DatapoolException(Messages.getString("Common_DatapoolFactoryImpl.21") + dpAbsolutePath); //$NON-NLS-1$
				}	
			}
			else //shared instance, already loaded
			{
				Integer refCount = ((Integer)datapoolRefCounts.remove(dpAbsolutePath));			
				Integer newRefCount =  new Integer(refCount.intValue()+1);
				DPLLogImpl.log("Refcount: " + newRefCount.intValue());			 //$NON-NLS-1$
				datapoolRefCounts.put(dpAbsolutePath,newRefCount);
				return dp;
			}		
		} //synchronized(this)
	}
	
	/**
	 * Removes a reference to an instance of a datapool.  If the
	 * datapool is shared the reference count is reduced.  Once 
	 * all references to a datapool have been unloaded the datapool
	 * instance will be made available to garbage collection.
	 * 
	 * @param	datapool	The datapool instance being unloaded.
	 * 
	 * @see	#load(java.io.File,boolean)
	 */
	public void unload(IDatapool datapool)
	{
		String dpAbsolutePath = ((DPLDatapoolImpl)datapool).getAbsoluteFilePathname();
		                      
		synchronized(this) {  //this is TEST&SET
		Integer refCount = ((Integer)datapoolRefCounts.remove(dpAbsolutePath));
		
			if (refCount != null && refCount.intValue() > 1)
			{			
				// decrement reference count
				Integer newRefCount =  new Integer(refCount.intValue()-1);
				DPLLogImpl.log("Refcount: " + newRefCount.intValue());			 //$NON-NLS-1$
				datapoolRefCounts.put(dpAbsolutePath, newRefCount);
			}
			else
			if (refCount != null && refCount.intValue() == 1)
			{
				//remove the reference
				DPLLogImpl.log("datapool uncached"); //$NON-NLS-1$
				datapoolsOpen.remove(dpAbsolutePath);
			}
			else
			{
				//datapool was not cached - do nothing
			}
		} //synchronized(this)
	}
	
	/**
	 * Persists the specified instance of a datapool.  The file 
	 * used is the same as the file from which the datapool was 
	 * loaded.  If the datapool was constructed from scratch the
	 * {@link #saveAs(IDatapool,java.io.File) saveAs} method
	 * should be used to save the file.
	 * 
	 * @param	datapool	The datapool instance being saved.
	 * 
	 * @see	#load(java.io.File,boolean)
	 * @see	#unload(IDatapool)
	 * @see	#saveAs(IDatapool,java.io.File)
	 */
	public void save(IDatapool datapool)
	{
		this.saveAs(datapool, new java.io.File(
			 ((DPLDatapoolImpl)datapool).getAbsoluteFilePathname()));
	}
	
	/**
	 * Persists the specified instance of a datapool to the 
	 * specified file.
	 * 
	 * @param	datapool	The datapool instance being saved.
	 * @param	dpFile		The file to which the datapool is to be saved.
	 * 
	 * @see	#load(java.io.File,boolean)
	 * @see	#unload(IDatapool)
	 * @see	#save(IDatapool)
	 */
	public void saveAs(IDatapool datapool, java.io.File dpFile)
	{
		try {
		String dpAbsolutePath = dpFile.getAbsolutePath();
		ResourceSet resourceSet = new ResourceSetImpl();
		URI fileURI = URI.createFileURI(dpAbsolutePath);
		
		Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
		Map m = reg.getExtensionToFactoryMap();
		m.put("xmi", new XMIResourceFactoryImpl());			  //$NON-NLS-1$
		resourceSet.getResourceFactoryRegistry();
		
		Resource res = resourceSet.createResource(fileURI);	
		DPLLogImpl.log("Save file: " + dpAbsolutePath); //$NON-NLS-1$
		res.getContents().add(datapool);
		res.save(Collections.EMPTY_MAP);
		}
		catch (Throwable t)
		{
			t.printStackTrace();
		}
 			
	}
	
	//org.eclipse.hyades.execution.runtime.datapool.IDatapoolFactory methods
	
	/**
	 * Load the datapool from the specified file.  If a
	 * <code>sharedInstance</code> is requested then the cache of
	 * other datapools that have been opened is checked for an 
	 * existing copy of the datapool.  Note that modifying a shared
	 * instance of the datapool may effect other uses of the datapool
	 * and should only be done in a confined execution environment.
	 * 
	 * @param	dpFile			The datapool file name.
	 * @param	sharedInstance	Available for sharing instances of
	 *						the datapool, which can save significantly 
	 *						on datapool loading overhead.
	 * 
	 * @see	#unload(IDatapool)
	 */
	public org.eclipse.hyades.execution.runtime.datapool.IDatapool load
											(java.io.File dpFile, boolean sharedInstance)
	{
		return (org.eclipse.hyades.execution.runtime.datapool.IDatapool)
						 (this.loadForEdit(dpFile, sharedInstance));
	}
	
	/**
	 * Removes a reference to an instance of a datapool.  If the
	 * datapool is shared the reference count is reduced.  Once 
	 * all references to a datapool have been unloaded the datapool
	 * instance may be made available to garbage collection.
	 * 
	 * @param	datapool	The datapool instance being unloaded.
	 * 
	 * @see	#load(java.io.File,boolean)
	 */
	public void unload(org.eclipse.hyades.execution.runtime.datapool.IDatapool datapool)
	{
		this.unload((IDatapool) datapool);
	}
	
	/**
	 * Return an iterator instance implemented by the extension with given extensionId.
	 * 
	 * 
	 * @param	datapool	The datapool instance being iterated over.
	 * 
	 * @see	#close(IDatapoolIterator)
	 */
	public org.eclipse.hyades.execution.runtime.datapool.IDatapoolIterator open
								  (org.eclipse.hyades.execution.runtime.datapool.IDatapool datapool,
								  String iteratorExtensionId)
	{
		
		//get extension point fot iterator extensions		
		org.eclipse.hyades.execution.runtime.datapool.IDatapoolIterator myIterator = null;
		Class myIteratorClass = null;
		
		try {
		    IExtensionPoint extPoint = Platform.getPluginRegistry().getExtensionPoint
			   ("org.eclipse.hyades.test.datapool.datapool_iterator");	    	        //$NON-NLS-1$
		    DPLLogImpl.log("iterator ext point found!!!"); //$NON-NLS-1$
		
		    //find all extensions
			IExtension[] extensions = extPoint.getExtensions();                
			DPLLogImpl.log("extensions.length: " + extensions.length); //$NON-NLS-1$
			
			//look for extension with id of iteratorExtensionId
			int i = 0;
			boolean found = false;
			while (!found && i < extensions.length)
			{                    	
				IExtension currentExtension = extensions[i];
				DPLLogImpl.log("   extension:" + currentExtension.getUniqueIdentifier()); //$NON-NLS-1$
				
				if (iteratorExtensionId.equals(currentExtension.getUniqueIdentifier()))
				{					
					IConfigurationElement[] configElements =
					   currentExtension.getConfigurationElements();
					DPLLogImpl.log("configElements.length : " + configElements.length); //$NON-NLS-1$
					//only one config element allowed
					IConfigurationElement currentConfigElement = configElements[0];
                    
					myIterator = (org.eclipse.hyades.execution.runtime.datapool.IDatapoolIterator)
							   currentConfigElement.createExecutableExtension("class"); //$NON-NLS-1$
						       
					DPLLogImpl.log("iterator: " + myIterator.toString()); //$NON-NLS-1$
					myIteratorClass = myIterator.getClass();
					found = true;	     																				    
				}
				else
				   i++;                   	   
			}
			if (!found)					    
			    throw new DatapoolException(Messages.getString("Common_DatapoolFactoryImpl.22") + iteratorExtensionId );  //$NON-NLS-1$
		}   
		catch (Throwable t) {			
			try 
			{
				myIteratorClass  = Class.forName(iteratorExtensionId);
				
			}
			catch (Throwable t1 )
			{
				t1.printStackTrace();
				throw new DatapoolException(Messages.getString("Common_DatapoolFactoryImpl.23") + iteratorExtensionId );  //$NON-NLS-1$
				
			}
		
		}				

		try
		{   		    
			java.lang.reflect.Method getInstanceMethod = (myIteratorClass.getMethod("getInstance", new java.lang.Class[0])); //$NON-NLS-1$
			return ((org.eclipse.hyades.execution.runtime.datapool.IDatapoolIterator)
							 getInstanceMethod.invoke(null, new Object[0]));    
		}
		catch (NoSuchMethodException e)
		{
			try {
			
				java.lang.reflect.Constructor ctor = myIteratorClass.getConstructor(new java.lang.Class[0]);
				return ((org.eclipse.hyades.execution.runtime.datapool.IDatapoolIterator)
					 ctor.newInstance(new Object[0]));
			}
			catch( Throwable t)
			{
				throw new DatapoolException(iteratorExtensionId + Messages.getString("Common_DatapoolFactoryImpl.25") + t.getMessage()); //$NON-NLS-1$
			}
		}
		catch (Throwable t)
		{
			throw new DatapoolException(iteratorExtensionId +Messages.getString("Common_DatapoolFactoryImpl.26") + t.getMessage()); //$NON-NLS-1$
		}
        		
	}
		
	/**
	 * Return the iterator to the factory so that it can be properly 
	 * destroyed.  Note that if shared the iterator will not be destructed 
	 * until all uses have been accounted for.
	 * 
	 * @param	iterator	The iterator being freed.
	 * 
	 * @see	#open(IDatapool,String)
	 */
	public void close(org.eclipse.hyades.execution.runtime.datapool.IDatapoolIterator iterator)
	{
		try
		{   		    
			java.lang.reflect.Method closeMethod = (iterator.getClass()).getMethod("close", new java.lang.Class[0]); //$NON-NLS-1$
			closeMethod.invoke(null, new Object[0]);    
		}
		catch (NoSuchMethodException e)
		{
			//do nothing
		}
		catch (Throwable t)
		{
			t.printStackTrace();
		}
	}
	
	public IDatapoolSuggestedType createDatapoolSuggestedType()
	{
		return new DatapoolSuggestedTypeImpl();
	}

	/**
	 * Constructs and returns an empty IDataPool
	 */
	public IDatapool constructDatapool()
	{
		DPLDatapoolImpl datapool = new DPLDatapoolImpl();
		DPLDatapoolSpecImpl datapoolSpec = new DPLDatapoolSpecImpl();
		datapool.setDatapoolSpec(datapoolSpec);
		return (IDatapool)datapool; 	
	}

} //Common_DatapoolFactoryImpl
