/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;

import java.util.Iterator;

import org.eclipse.hyades.loaders.hierarchy.Constants;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCHeapDump;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.impl.TRCHeapDumpImpl;
/**
 * @author slavescu
 *
 */
public class XMLheapDumpDefLoader extends TraceXMLFragmentLoader {
    //~ Static fields/initializers -----------------------------------------------------------------

//    protected static final String NAME = "name";
    protected static final String BASE_TIME = "basetime";
    protected static final String HEAP_DUMP_ID = "heapDumpId";

    //~ Instance fields ----------------------------------------------------------------------------

	protected String name;
    protected double baseTime;
    protected short heapDumpId;

    //~ Methods ------------------------------------------------------------------------------------

    public void addAttribute(String name, String value) {

        switch (LoadersUtils.getHashCode(name)) {
        case TraceConstants.NAME_int:
            this.name = value;
            break;

        case TraceConstants.BASE_TIME_int:
            baseTime = Double.parseDouble(value);
            break;

        case TraceConstants.HEAP_DUMP_ID_int:
            heapDumpId = Short.parseShort(value);
            break;

        default:
            super.addAttribute(name, value);
            break;
        }
    }

    public void addYourselfInContext() {
    	dispatchProcessMode(ProcessSteps.ALL);
    }

	private void createHeapDump() {
		theProcess = getProcess();
		
		//TODO: MS create a new collection boundary for each heap dump
		//		Also put heapdumps in different resources
		if(!TraceUtils.isBooleanOptionEnabled(context,Constants.MULTIPLE_HEAP_DUMPS))
			removePreviousHeapDump(theProcess);
		
		theHeapDump = (TRCHeapDump)LookupServiceExtensions.getInstance().locate(context,TRCHeapDumpImpl.class,LoadersUtils.getLookUpKey(heapDumpId));
		if(theHeapDump==null)
		{
			theHeapDump = TraceFactory.eINSTANCE.createTRCHeapDump();
			theHeapDump.setId(heapDumpId);
		}
		theHeapDump.setName(name);
		theHeapDump.setEntryTime(createDeltaTime());
		theHeapDump.setProcess(theProcess);
	}

	protected void removePreviousHeapDump(TRCProcess p) {
		for (Iterator iter = p.getHeapDumps().iterator(); iter.hasNext();) {
			TRCHeapDump element = (TRCHeapDump) iter.next();
			TRCObjectReference[] references = (TRCObjectReference[]) element.getReferences().toArray(new TRCObjectReference[element.getReferences().size()]);
			for (int i = 0; i < references.length; i++) {
				references[i].setOwner(null);
				references[i].setTarget(null);
				references[i].setHeapDump(null);
			}
		}
		p.getHeapDumps().clear();
	} 
	public void initialize(HierarchyContext context, String name) {
        loadToModel = context.isLoadToModel();

        super.initialize(context, name);
        
        name = null;
        baseTime = 0;
        heapDumpId = 0;
    }
    
	/**
	 *
	 */

	protected void processHF(int step) {
		super.processHF(step);
		createHeapDump();
	}

	/**
	 *
	 */

	protected void processHS(int step) {
		super.processHS(step);
		createHeapDump();
	}

}
