package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * This base class defines the interface for the SimpleEventFactory.
 * 
 * The SimpleEventFactory is a singleton as prescribed by the 
 * Abstract Factory pattern (Gamma et.al.).  It contains simple
 * constructors to build CommonBaseEvent and related complex 
 * type objects.
 * 
 * @author Richard K. Duggan
 * @author Paul E. Slauenwhite
 * @author John K. Gerken
 * @version 1.0.1
 * @since 1.0
 * @deprecated This class is deprecated as of 2004-05-17. Use the corresponding class available in org.eclipse.hyades.logging.events.cbe*
 */
public interface ISimpleEventFactory {

    /**
     * Method IMsgCatalogToken.
     * 
     * Create and return a concrete MsgCatalogToken object.  Objects
     * of this type are encapsulated into MsgDataElement objects.
     * 
     * @return IMsgCatalogToken
     */
    public IMsgCatalogToken createMsgCatalogToken();

    /**
     * Method IAssociationEngine.
     * 
     * Create and return a concrete AssociationEngine object.  Objects
     * of this type are encapsulated into CommonBaseEvent objects.
     * 
     * @return IAssociationEngine
     */
    public IAssociationEngine createAssociationEngine();

    /**
     * Method createCommonBaseEvent.
     * 
     * Create and return a concrete CommonBaseEvent object.
     * 
     * @return ICommonBaseEvent
     */
    public ICommonBaseEvent createCommonBaseEvent();

    /**
     * Method createExtendedDataElement.
     * 
     * Create and return a concrete ExtendedDataElement object.  Objects
     * of this type are encapsulated into CommonBaseEvent objects.
     * 
     * @return IExtendedDataElement
     */
    public IExtendedDataElement createExtendedDataElement();

    /**
     * Method createAssociatedEvent.
     * 
     * Create and return a concrete AssociatedEvent object.  Objects
     * of this type are encapsulated into CommonBaseEvent objects.
     * 
     * @return IAssociatedEvent
     */
    public IAssociatedEvent createAssociatedEvent();

    /**
     * Method createContextDataElement.
     * 
     * Create and return a concrete ContextDataElement object.  Objects
     * of this type are encapsulated into CommonBaseEvent objects.
     * 
     * @return IContextDataElement
     */
    public IContextDataElement createContextDataElement();

    /**
     * Method createAnyElement.
     * 
     * Create and return a concrete AnyElement object.  Objects
     * of this type are encapsulated into CommonBaseEvent objects.
     * 
     * @return ICommonBaseEventAnyElement
     * @deprecated Use the otherData as of 1.0.1.
     */
    public ICommonBaseEventAnyElement createAnyElement();

    /**
     * Method createComponentIdentification.
     * 
     * Create and return a concrete ComponentIdentification object.  Objects
     * of this type are encapsulated into CommonBaseEvent objects.
     * 
     * @return IComponentIdentification
     */
    public IComponentIdentification createComponentIdentification();

    /**
     * Method createMsgDataElement.
     * 
     * Create and return a concrete MsgDataElement object.  Objects
     * of this type are encapsulated into CommonBaseEvent objects.
     * 
     * @return IMsgDataElement
     */
    public IMsgDataElement createMsgDataElement();

    /**
     * Method createMsgDataElement.
     * 
     * Create and return a concrete Situation object.  Objects
     * of this type are encapsulated into CommonBaseEvent objects.
     * 
     * @return ISituation
     * @since 1.0.1
     */
    public ISituation createSituation();

    /**
     * Method createStartSituation.
     * 
     * Create and return a concrete StartSituation object.  Objects
     * of this type are encapsulated into CommonBaseEvent objects.
     * 
     * @return IStartSituation
     * @since 1.0.1
     */
    public IStartSituation createStartSituation();

    /**
     * Method createStopSituation.
     * 
     * Create and return a concrete StopSituation object.  Objects
     * of this type are encapsulated into CommonBaseEvent objects.
     * 
     * @return IStopSituation
     * @since 1.0.1
     */
    public IStopSituation createStopSituation();

    /**
     * Method createConnectSituation.
     * 
     * Create and return a concrete ConnectSituation object.  Objects
     * of this type are encapsulated into CommonBaseEvent objects.
     * 
     * @return IConnectSituation
     * @since 1.0.1
     */
    public IConnectSituation createConnectSituation();

    /**
     * Method createReportSituation.
     * 
     * Create and return a concrete ReportSituation object.  Objects
     * of this type are encapsulated into CommonBaseEvent objects.
     * 
     * @return IReportSituation
     * @since 1.0.1
     */
    public IReportSituation createReportSituation();

    /**
     * Method createFeatureSituation.
     * 
     * Create and return a concrete FeatureSituation object.  Objects
     * of this type are encapsulated into CommonBaseEvent objects.
     * 
     * @return IFeatureSituation
     * @since 1.0.1
     */
    public IFeatureSituation createFeatureSituation();

    /**
     * Method createConfigureSituation.
     * 
     * Create and return a concrete ConfigureSituation object.  Objects
     * of this type are encapsulated into CommonBaseEvent objects.
     * 
     * @return IConfigureSituation
     * @since 1.0.1
     */
    public IConfigureSituation createConfigureSituation();

    /**
     * Method createDependencySituation.
     * 
     * Create and return a concrete DependencySituation object.  Objects
     * of this type are encapsulated into CommonBaseEvent objects.
     * 
     * @return IDependencySituation
     * @since 1.0.1
     */
    public IDependencySituation createDependencySituation();

    /**
     * Method createCreateSituation.
     * 
     * Create and return a concrete CreateSituation object.  Objects
     * of this type are encapsulated into CommonBaseEvent objects.
     * 
     * @return ICreateSituation
     * @since 1.0.1
     */
    public ICreateSituation createCreateSituation();

    /**
     * Method createDestroySituation.
     * 
     * Create and return a concrete DestroySituation object.  Objects
     * of this type are encapsulated into CommonBaseEvent objects.
     * 
     * @return IDestroySituation
     * @since 1.0.1
     */
    public IDestroySituation createDestroySituation();

    /**
     * Method createAvailableSituation.
     * 
     * Create and return a concrete AvailableSituation object.  Objects
     * of this type are encapsulated into CommonBaseEvent objects.
     * 
     * @return IAvailableSituation
     * @since 1.0.1
     */
    public IAvailableSituation createAvailableSituation();

    /**
     * Method createRequestSituation.
     * 
     * Create and return a concrete RequestSituation object.  Objects
     * of this type are encapsulated into CommonBaseEvent objects.
     * 
     * @return IRequestSituation
     * @since 1.0.1
     */
    public IRequestSituation createRequestSituation();

    /**
     * Method createOtherSituation.
     * 
     * Create and return a concrete OtherSituation object.  Objects
     * of this type are encapsulated into CommonBaseEvent objects.
     * 
     * @return IOtherSituation
     * @since 1.0.1
     */
    public IOtherSituation createOtherSituation();

    /**
     * Method createCommonBaseEvent.
     * 
     * Create and return a concrete CommonBaseEvent object.
     * 
     * @return ICommonBaseEvent
     */
    public ICommonBaseEvent createCommonBaseEvent(String extensionName);

	/**
	 * Method createCommonBaseEvent.
	 * 
	 * Create and return a concrete CommonBaseEvent object.
	 * 
	 * @return ICommonBaseEvent
	 */
    public ICommonBaseEvent createCommonBaseEvent(String extensionName, long creationTime);

	/**
	 * Method createGlobalInstanceId.
	 * 
	 * Create and return a  Global Instance ID (GUID).
	 * 
	 * @return String
	 */
    public String createGlobalInstanceId();
}