/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal;

import java.util.Map;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.hyades.models.hierarchy.util.IHyadesExtendedResource;
/**
 * This interface represents a database resource. The objects in the resource
 * come from a database or are saved in a database. A DBResource uses a Database
 * object to perform database actions.
 */
public interface DBResource extends IHyadesExtendedResource {
	/**
	 * This load option allows you to control whether just the top level objects
	 * are retrieved from the database, or whether all objects in the resource
	 * are retrieved. If this option is set to true, only the top level objects
	 * are retrieved.
	 */
	String OPTION_TOP_LEVEL = "TOP_LEVEL";

	/**
	 * This load option allows you to control which objects are created during a
	 * database load. The instances of the EClass you give as the value for this
	 * option are not loaded. If multi-valued references whose types are the
	 * EClasses are changed to create paging lists, then you can traverse all
	 * objects in the DBResource and get paging list behavior.
	 * <p>
	 * The value of this option needs to be a collection containing the classes
	 * whose instances are not to be loaded.
	 */
	String OPTION_NOT_LOADED_CLASSES = "NOT_LOADED_CLASSES";

	Database getDatabase();

	/**
	 * The database must be open and its DBMap must be set before invoking a
	 * load or a save method.
	 */
	void setDatabase(Database database);

	/**
	 * You can specify default load options that will be used when you invoke
	 * load without any options.
	 */
	Map getDefaultLoadOptions();

	/**
	 * Returns an EObject that satisfies the following criteria:
	 * <ul>
	 * <li>It is in the resource
	 * <li>It is an instance of the given EClass
	 * <li>It has an attribute value that matches the given value for the given
	 * attribute (if attribute is null, the Ecore ID attribute for the given
	 * class is used).
	 * <li>If related and reference are not null, the reference for the object
	 * has related as one of its values.
	 * </ul>
	 * If there is more than one object, the first one is returned.
	 */
	EObject getEObject(EClass eClass, EAttribute attribute, Object value, EObject related, EReference reference) throws Exception;

	/**
	 * This method returns true if the DBResource is in the database. This
	 * happens if a DBResource is successfully loaded from the database or saved
	 * in the database.
	 */
	boolean isInDatabase();

	/**
	 * Returns the content adapter for this resource.
	 */
	EContentAdapter getContentAdapter();
} // DBResource
