/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.ResultSet;
import java.sql.Statement;

import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
/**
 * This class computes the index of the given targetId for the given sourceId
 * and reference if last is false; if last is true, it computes the lastIndex.
 */
public class GetIndex extends DBCommand {
	protected Integer sourceId, targetId;
	protected EReference reference;
	protected boolean last;

	public GetIndex(JDBCHelper helper, DBMap map, Integer sourceId, EReference reference, Integer targetId, boolean last) {
		super(helper, map);
		this.sourceId = sourceId;
		this.reference = reference;
		this.targetId = targetId;
		this.last = last;
	}

	/**
	 * Return an array of EObjects, or null.
	 */
	public Object execute() throws Exception {
		StatementFactory factory = StatementFactory.INSTANCE;
		QueryStatement query = factory.createIndexQuery(helper.getDatabaseType(), dbMap, sourceId, reference, targetId);
		Statement statement = helper.createStatement();
		ResultSet rs = helper.executeQuery(statement, query.getStatement());
		int index = -1;

		while (rs.next()) {
			int temp = rs.getInt(1);

			if (last && temp > index)
				index = temp;
			else if (!last && (index == -1 || temp < index))
				index = temp;
		}

		rs.close();
		statement.close();
		return new Integer(index);
	}
} // GetIndex
