/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.runner;

/**
 * HTTP request and response header.
 * 
 * @author marcelop
 * @since 1.0.2
 */
public class HttpHeader
{
	public static final String VALUE_TOKEN = ": ";

	public static boolean isValid(HttpHeader header)
	{
		return ((header != null) && (header.getName() != null));
	}
		 
	private String name;
	private String value;
	
	private HttpElement element;
	
	/**
	 * @return
	 */
	public HttpElement getElement()
	{
		return element;
	}

	/**
	 * @param element
	 */
	public void setElement(HttpElement element)
	{
		this.element = element;
	}

	/**
	 * @return
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * @param name
	 */
	public void setName(String name)
	{
		this.name = name;
	}

	/**
	 * @return
	 */
	public String getValue()
	{
		return value;
	}

	/**
	 * @param value
	 */
	public void setValue(String value)
	{
		this.value = value;
	}
	
	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		return name + ((value != null)?(VALUE_TOKEN + value):"");
	}
}
