/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.wizard;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

/**
 * Extension of WizardNewFileCreationPage that allows the definition of a
 * required file extension to be used.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class LocationPage 
extends WizardNewFileCreationPage
{
	private String fileExtension;
	private boolean allowOverwrite;
	
	/**
	 * Constructor for LocationPage
	 * @param pageName
	 * @param selection
	 */
	public LocationPage(String pageName, IStructuredSelection selection)
	{
		super(pageName, selection);
		allowOverwrite = false;
	}
	
	public void setAllowOverwrite(boolean allowOverwrite)
	{
		this.allowOverwrite = allowOverwrite;
	}
	
	public boolean allowOverwrite()
	{
		return allowOverwrite;
	}
	
	/**
	 * Sets the required file extension.
	 * @param fileExtension
	 */
	public void setFileExtension(String fileExtension)
	{
		this.fileExtension = fileExtension;
	}
	
	/**
	 * Returns the required file extension.
	 * @return Sting
	 */
	public String getFileExtension()
	{
		return fileExtension;
	}

	/**
	 * @see org.eclipse.ui.dialogs.WizardNewFileCreationPage#validatePage()
	 */
	protected boolean validatePage()
	{
		setMessage(null);		

		if(!allowOverwrite())
		{
			IPath path = getContainerFullPath();
			if(path != null)
			{
				String fileName = getFileName();
				if(fileName.length() == 0) {
					setErrorMessage(null);
					return false;
				} else if (fileName.startsWith(".")) {
					setErrorMessage(HyadesUIPlugin.getString("_ERROR_FILE_NAME_EXT"));
					return false;					
				}
				
				if(!fileName.endsWith("."+ fileExtension))
					fileName = fileName + "." + fileExtension;

				IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path.append(fileName));
				if((resource != null) && (resource.exists()))
				{
					setErrorMessage(IDEWorkbenchMessages.format("ResourceGroup.nameExists", new String[] {fileName})); //$NON-NLS-1$);
					return false;
				} 
			}
		}		

		if(super.validatePage())
			return true;

		return false;
	}
}
