/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.java.internal.junit.wizard;

import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.common.TestCommon;
import org.eclipse.hyades.test.common.internal.wizard.TestCaseNewWizard;
import org.eclipse.hyades.test.java.TestJavaImages;
import org.eclipse.hyades.test.java.TestJavaPlugin;

/**
 * Wizard for the JUnit Test Case
 * 
 * @author marcelop
 * @since 0.3.0
 */
public class JUnitTestCaseNewWizard
extends TestCaseNewWizard
{
	/**
	 * Constructor for TestCaseNewWizard
	 */
	public JUnitTestCaseNewWizard()
	{
		super();

		setWindowTitle(TestJavaPlugin.getString("WIZ_JUNIT_TST_CASE_TTL"));
		setDefaultPageImageDescriptor(TestJavaImages.INSTANCE.getImageDescriptor(TestJavaImages.IMG_WIZBAN_NEW_JUNIT_TESTCASE));
	}

	/**
	 * Returns the type for the test case created by this wizard.
	 * @return String
	 */
	protected String getType()
	{
		return TestCommon.JUNIT_TEST_CASE_TYPE;
	}
	
	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
        ITestSuite testSuite = getTestSuite();
        String label = testSuite != null ? testSuite.getName() : ""; //$NON-NLS-1$

        getAttributeWizardPage().setTitle(TestJavaPlugin.getString("WIZ_NEW_JUNIT_TST_CASE_PG_TTL")); //$NON-NLS-1$
        getAttributeWizardPage().setDescription(TestJavaPlugin.getString("WIZ_NEW_JUNIT_TST_CASE_PG_ATT_DSC", label)); //$NON-NLS-1$
        addPage(getAttributeWizardPage());
	}
}
