/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.remote;

import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.core.IProcessConsole;

/**
 * @author rduggan
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class ExecutorSkeleton extends ExecutionComponentSkeleton implements IExecutor {

	public ExecutorSkeleton() {
		super();
	}
	public ExecutorSkeleton(IExecutionComponent delegate, Integer id) {
		super(delegate, id);
	}
	
	/** 
	 * @see org.eclipse.hyades.execution.core.IExecutor#launch()
	 */
	public void launch() throws ExecutionComponentStateException {
		((IExecutor)delegate).launch();
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutor#kill()
	 */
	public void kill() throws ExecutionComponentStateException {
		((IExecutor)delegate).kill();

	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutor#setExecutableObject(org.eclipse.hyades.execution.core.IExecutableObject)
	 */
	public void setExecutableObject(IExecutableObject theExecutableObject) throws ExecutionComponentStateException {
		((IExecutor)delegate).setExecutableObject(theExecutableObject);
	}
	
	/**
	 * @see org.eclipse.hyades.execution.core.IExecutor#getExecutableObject()
	 */
	public IExecutableObject getExecutableObject()
	{
		return ((IExecutor)delegate).getExecutableObject();
	}
	
	/**
	 * @see org.eclipse.hyades.execution.core.IExecutor#getProcessConsole()
	 */
	public IProcessConsole getProcessConsole() throws ExecutionComponentStateException {
		return ((IExecutor)delegate).getProcessConsole();
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutor#getCompatibleExecutableObject()
	 */
	public IExecutableObject getCompatibleExecutableObject(String classname) throws ClassNotFoundException {
		return ((IExecutor)delegate).getCompatibleExecutableObject(classname);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.IExecutor#performControlEvent(java.lang.String)
	 */
	public String performControlEvent(String controlEvent, String[] params) {
		return "";
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.IExecutor#supportsControlEvent(java.lang.String)
	 */
	public boolean supportsControlEvent(String controlEvent) {
		return false;
	}

}
